/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.device;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.equinox.device.Activator;
import org.eclipse.equinox.device.DeviceMsg;
import org.eclipse.equinox.device.DriverTracker;
import org.eclipse.equinox.device.LogTracker;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.service.device.Device;
import org.osgi.util.tracker.ServiceTracker;

public class DeviceTracker
extends ServiceTracker {
    protected static final String clazz = "org.osgi.service.device.Device";
    protected Activator manager;
    protected ServiceReference device;
    protected LogTracker log;
    protected Dictionary properties;
    protected volatile boolean running;

    public DeviceTracker(Activator manager, ServiceReference device) {
        super(manager.context, device, null);
        this.manager = manager;
        this.log = manager.log;
        this.open();
    }

    public void close() {
        if (this.device != null) {
            this.running = false;
            super.close();
            this.device = null;
        }
    }

    public Object addingService(ServiceReference reference) {
        this.device = reference;
        this.running = true;
        this.properties = new Properties(reference);
        return reference;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.properties = new Properties(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        if (this.running) {
            this.log.log(reference, 2, DeviceMsg.Device_service_unregistered);
            this.running = false;
        }
        super.removedService(reference, service);
    }

    public void refine() {
        if (this.running && this.isIdle()) {
            DriverTracker drivers = this.manager.drivers;
            this.manager.locators.loadDrivers(this.properties, drivers);
            Vector exclude = new Vector(drivers.size());
            while (this.running) {
                ServiceReference driver = drivers.match(this.device, exclude);
                if (driver == null) {
                    this.noDriverFound();
                    break;
                }
                if (drivers.attach(driver, this.device, exclude)) break;
            }
        }
        this.close();
    }

    public boolean isIdle() {
        Filter filter_ = this.manager.driverFilter;
        Bundle[] users = this.device.getUsingBundles();
        int userCount = users == null ? 0 : users.length;
        int i = 0;
        while (i < userCount) {
            ServiceReference[] services = users[i].getRegisteredServices();
            int servicesCount = services == null ? 0 : services.length;
            int j = 0;
            while (j < servicesCount) {
                if (filter_.match(services[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public void noDriverFound() {
        BundleContext contxt = this.manager.context;
        Object service = contxt.getService(this.device);
        try {
            if (service instanceof Device) {
                this.log.log(this.device, 3, DeviceMsg.Device_noDriverFound_called);
                try {
                    ((Device)service).noDriverFound();
                }
                catch (Throwable t) {
                    this.log.log(this.device, 1, NLS.bind((String)DeviceMsg.Device_noDriverFound_error, (Object)t));
                }
            }
        }
        finally {
            contxt.ungetService(this.device);
        }
    }

    public String toString() {
        return "DeviceTracker";
    }

    static class Properties
    extends Hashtable {
        private static final long serialVersionUID = -8489170394007899809L;
        protected Vector keys;

        protected Properties(ServiceReference device) {
            String[] props = device.getPropertyKeys();
            if (props != null) {
                int size = props.length;
                this.keys = new Vector(size);
                int i = 0;
                while (i < size) {
                    String key = props[i];
                    Object value = device.getProperty(key);
                    if (value != null) {
                        this.keys.addElement(key);
                        super.put(key.toLowerCase(), value);
                    }
                    ++i;
                }
            } else {
                this.keys = new Vector(0);
            }
        }

        public Enumeration keys() {
            return this.keys.elements();
        }

        public Object get(Object key) {
            if (key instanceof String) {
                return super.get(((String)key).toLowerCase());
            }
            return null;
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }
    }
}

