/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.metatype.EquinoxMetaTypeService;
import org.eclipse.equinox.metatype.impl.LogTracker;
import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.equinox.metatype.impl.MetaTypeServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator {
    private static final String FILTER = "(|(&(objectClass=" + ManagedService.class.getName() + "*)(" + "service.pid" + "=*))(&(" + "objectClass" + '=' + MetaTypeProvider.class.getName() + ")(|(" + "metatype.pid" + "=*)(" + "metatype.factory.pid" + "=*))))";
    private static final String SERVICE_PID = "org.osgi.impl.service.metatype.MetaTypeService";
    private LogTracker logServiceTracker;
    private ServiceTracker<Object, Object> metaTypeProviderTracker;
    private ServiceTracker<SAXParserFactory, SAXParserFactory> saxParserFactoryTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws InvalidSyntaxException {
        ServiceTracker spfTracker;
        ServiceTracker mtpTracker;
        LogTracker lsTracker;
        Filter filter = context.createFilter(FILTER);
        Activator activator = this;
        synchronized (activator) {
            lsTracker = this.logServiceTracker = new LogTracker(context, System.out);
            mtpTracker = this.metaTypeProviderTracker = new ServiceTracker(context, filter, null);
            spfTracker = this.saxParserFactoryTracker = new ServiceTracker(context, SAXParserFactory.class, (ServiceTrackerCustomizer)new SAXParserFactoryTrackerCustomizer(context, lsTracker, (ServiceTracker<Object, Object>)mtpTracker));
        }
        lsTracker.open();
        lsTracker.log(4, "====== Meta Type Service starting ! =====");
        mtpTracker.open();
        spfTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) {
        LogTracker lsTracker;
        ServiceTracker<Object, Object> mtpTracker;
        ServiceTracker<SAXParserFactory, SAXParserFactory> spfTracker;
        Activator activator = this;
        synchronized (activator) {
            spfTracker = this.saxParserFactoryTracker;
            this.saxParserFactoryTracker = null;
            mtpTracker = this.metaTypeProviderTracker;
            lsTracker = this.logServiceTracker;
        }
        lsTracker.log(4, "====== Meta Type Service stopping ! =====");
        spfTracker.close();
        mtpTracker.close();
        lsTracker.close();
    }

    synchronized ServiceTracker<SAXParserFactory, SAXParserFactory> getSAXParserFactoryTracker() {
        return this.saxParserFactoryTracker;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SAXParserFactoryTrackerCustomizer
    implements ServiceTrackerCustomizer<SAXParserFactory, SAXParserFactory> {
        private final BundleContext bundleCtx;
        private final LogTracker logService;
        private final ServiceTracker<Object, Object> mtpTracker;
        private MetaTypeServiceImpl metaTypeService;
        private ServiceRegistration<?> metaTypeServiceRegistration;
        private SAXParserFactory saxParserFactory;

        public SAXParserFactoryTrackerCustomizer(BundleContext bundleContext, LogTracker logService, ServiceTracker<Object, Object> metaTypeProviderTracker) {
            this.bundleCtx = bundleContext;
            this.logService = logService;
            this.mtpTracker = metaTypeProviderTracker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SAXParserFactory addingService(ServiceReference<SAXParserFactory> ref) {
            SAXParserFactory parserFactory = (SAXParserFactory)this.bundleCtx.getService(ref);
            if (parserFactory == null) {
                return null;
            }
            ServiceRegistration<?> registration = null;
            MetaTypeServiceImpl service = null;
            SAXParserFactory oldFactory = null;
            SAXParserFactoryTrackerCustomizer sAXParserFactoryTrackerCustomizer = this;
            synchronized (sAXParserFactoryTrackerCustomizer) {
                if (this.saxParserFactory == null) {
                    this.saxParserFactory = parserFactory;
                } else {
                    if (this.saxParserFactory.isNamespaceAware()) {
                        return parserFactory;
                    }
                    if (parserFactory.isNamespaceAware() || !this.supportsNamespaceAwareness(this.saxParserFactory) && this.supportsNamespaceAwareness(parserFactory)) {
                        oldFactory = this.saxParserFactory;
                        this.saxParserFactory = parserFactory;
                        registration = this.metaTypeServiceRegistration;
                        service = this.metaTypeService;
                    }
                }
            }
            this.swapFactories(oldFactory, parserFactory, registration, service);
            return parserFactory;
        }

        private void swapFactories(SAXParserFactory oldFactory, SAXParserFactory newFactory, ServiceRegistration<?> registration, MetaTypeServiceImpl service) {
            if (oldFactory == null) {
                this.registerMetaTypeService();
                return;
            }
            this.unregisterMetaTypeService(registration, service);
            this.registerMetaTypeService();
        }

        public void modifiedService(ServiceReference<SAXParserFactory> ref, SAXParserFactory object) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference<SAXParserFactory> ref, SAXParserFactory object) {
            ServiceRegistration<?> registration = null;
            MetaTypeServiceImpl service = null;
            SAXParserFactoryTrackerCustomizer sAXParserFactoryTrackerCustomizer = this;
            synchronized (sAXParserFactoryTrackerCustomizer) {
                if (object == this.saxParserFactory) {
                    this.saxParserFactory = null;
                    registration = this.metaTypeServiceRegistration;
                    service = this.metaTypeService;
                }
            }
            if (registration != null) {
                this.unregisterMetaTypeService(registration, service);
                SAXParserFactory factory = this.findBestPossibleFactory();
                if (factory != null) {
                    boolean register = false;
                    SAXParserFactoryTrackerCustomizer sAXParserFactoryTrackerCustomizer2 = this;
                    synchronized (sAXParserFactoryTrackerCustomizer2) {
                        if (this.saxParserFactory == null) {
                            this.saxParserFactory = factory;
                            register = true;
                        }
                    }
                    if (register) {
                        this.registerMetaTypeService();
                    }
                }
            }
            this.bundleCtx.ungetService(ref);
        }

        private SAXParserFactory findBestPossibleFactory() {
            ServiceTracker<SAXParserFactory, SAXParserFactory> tracker = Activator.this.getSAXParserFactoryTracker();
            if (tracker == null) {
                return null;
            }
            SAXParserFactory[] factories = (SAXParserFactory[])tracker.getServices();
            if (factories == null) {
                return null;
            }
            SAXParserFactory result = null;
            SAXParserFactory[] sAXParserFactoryArray = factories;
            int n = factories.length;
            int n2 = 0;
            while (n2 < n) {
                SAXParserFactory factory = sAXParserFactoryArray[n2];
                if (factory.isNamespaceAware()) {
                    result = factory;
                    break;
                }
                if (result == null && this.supportsNamespaceAwareness(factory)) {
                    result = factory;
                }
                ++n2;
            }
            if (result == null) {
                result = (SAXParserFactory)tracker.getService();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerMetaTypeService() {
            MetaTypeServiceImpl service;
            Hashtable<String, String> properties = new Hashtable<String, String>(7);
            properties = new Hashtable(7);
            ((Dictionary)properties).put("service.vendor", "IBM");
            ((Dictionary)properties).put("service.description", MetaTypeMsg.SERVICE_DESCRIPTION);
            ((Dictionary)properties).put("service.pid", Activator.SERVICE_PID);
            SAXParserFactoryTrackerCustomizer sAXParserFactoryTrackerCustomizer = this;
            synchronized (sAXParserFactoryTrackerCustomizer) {
                service = this.metaTypeService = new MetaTypeServiceImpl(this.saxParserFactory, this.logService, this.mtpTracker);
            }
            this.bundleCtx.addBundleListener((BundleListener)service);
            ServiceRegistration registration = this.bundleCtx.registerService(new String[]{MetaTypeService.class.getName(), EquinoxMetaTypeService.class.getName()}, (Object)service, properties);
            SAXParserFactoryTrackerCustomizer sAXParserFactoryTrackerCustomizer2 = this;
            synchronized (sAXParserFactoryTrackerCustomizer2) {
                this.metaTypeServiceRegistration = registration;
            }
        }

        private boolean supportsNamespaceAwareness(SAXParserFactory factory) {
            if (factory.isNamespaceAware()) {
                return true;
            }
            factory.setNamespaceAware(true);
            try {
                factory.newSAXParser();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
            finally {
                factory.setNamespaceAware(false);
            }
        }

        private void unregisterMetaTypeService(ServiceRegistration<?> registration, MetaTypeServiceImpl service) {
            registration.unregister();
            this.bundleCtx.removeBundleListener((BundleListener)service);
        }
    }
}

