/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin.dialogs;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.dialogs.IUGroup;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class IUImplementationGroup
extends IUGroup {
    private Text id;
    private Text version;
    private Text namespace;
    private Text touchpointType;
    private List touchpointData;
    private List requiredCapabilities;
    private List providedCapabilities;

    public IUImplementationGroup(Composite parent, IInstallableUnit iu, ModifyListener listener) {
        super(parent, iu, listener);
    }

    @Override
    protected Composite createGroupComposite(Composite parent, ModifyListener listener) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.widthHint = 350;
        composite.setLayoutData((Object)data);
        GridData gd = new GridData(768);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 2;
        GridData gdList = new GridData(768);
        GC gc = new GC((Drawable)parent);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        gdList.horizontalSpan = 2;
        gdList.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)5);
        boolean editable = this.iuElement == null && listener != null;
        Label label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.IUGroup_ID);
        this.id = new Text(composite, 2048);
        this.id.setLayoutData((Object)gd);
        if (editable) {
            this.id.addModifyListener(listener);
        } else {
            this.id.setEditable(false);
        }
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.IUGroup_Version);
        this.version = new Text(composite, 2048);
        this.version.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.IUGroup_Namespace);
        this.namespace = new Text(composite, 2048);
        this.namespace.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.IUGroup_TouchpointType);
        this.touchpointType = new Text(composite, 2056);
        this.touchpointType.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.IUGroup_TouchpointData);
        label.setLayoutData((Object)gd2);
        this.touchpointData = new List(composite, 2818);
        this.touchpointData.setLayoutData((Object)gdList);
        this.createCopyMenu(this.touchpointData);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.IUGroup_RequiredCapabilities);
        label.setLayoutData((Object)gd2);
        this.requiredCapabilities = new List(composite, 2818);
        this.requiredCapabilities.setLayoutData((Object)gdList);
        this.createCopyMenu(this.requiredCapabilities);
        label = new Label(composite, 0);
        label.setText(ProvAdminUIMessages.IUGroup_ProvidedCapabilities);
        label.setLayoutData((Object)gd2);
        this.providedCapabilities = new List(composite, 2818);
        this.providedCapabilities.setLayoutData((Object)gdList);
        this.createCopyMenu(this.providedCapabilities);
        if (editable) {
            this.id.addModifyListener(listener);
            this.version.addModifyListener(listener);
            this.namespace.addModifyListener(listener);
            this.touchpointType.addModifyListener(listener);
        } else {
            this.id.setEditable(false);
            this.version.setEditable(false);
            this.namespace.setEditable(false);
            this.touchpointType.setEditable(false);
        }
        this.initializeFields();
        return composite;
    }

    private void initializeFields() {
        ITouchpointType type;
        IInstallableUnit iu = this.getIU();
        if (iu == null) {
            return;
        }
        this.id.setText(iu.getId());
        this.version.setText(iu.getVersion().toString());
        String value = iu.getProperty("org.eclipse.equinox.p2.iu");
        if (value != null) {
            this.namespace.setText(value);
        }
        if ((type = iu.getTouchpointType()) != null) {
            this.touchpointType.setText(type.getId());
        }
        Collection data = iu.getTouchpointData();
        String[] items = new String[data.size()];
        int i = 0;
        for (ITouchpointData td : data) {
            items[i++] = td.toString();
        }
        this.touchpointData.setItems(items);
        Collection reqs = iu.getRequirements();
        items = new String[reqs.size()];
        i = 0;
        for (IRequirement req : reqs) {
            items[i++] = req.toString();
        }
        this.requiredCapabilities.setItems(items);
        Collection prov = iu.getProvidedCapabilities();
        items = new String[prov.size()];
        i = 0;
        for (IProvidedCapability capability : prov) {
            items[i++] = capability.toString();
        }
        this.providedCapabilities.setItems(items);
    }

    @Override
    public void updateIU() {
        if (this.iuElement == null || this.iuElement instanceof IInstallableUnit) {
            MetadataFactory.InstallableUnitDescription unit = new MetadataFactory.InstallableUnitDescription();
            unit.setId(this.id.getText().trim());
            unit.setVersion(Version.create((String)this.version.getText().trim()));
            unit.setProperty("org.eclipse.equinox.p2.iu", this.namespace.getText().trim());
            unit.setTouchpointType(MetadataFactory.createTouchpointType((String)this.touchpointType.getText().trim(), (Version)Version.create((String)"1.0.0")));
            this.iuElement = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)unit);
        }
    }

    public IStatus verify() {
        if (this.id.getText().trim().length() == 0) {
            return new Status(4, "org.eclipse.equinox.internal.provisional.p2.ui.admin", 0, ProvAdminUIMessages.IUGroup_IU_ID_Required, null);
        }
        return new Status(0, "org.eclipse.equinox.internal.provisional.p2.ui.admin", 0, "", null);
    }

    private void createCopyMenu(final List list) {
        Menu copyMenu = new Menu((Control)list);
        MenuItem copyItem = new MenuItem(copyMenu, 0);
        copyItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IUImplementationGroup.this.copySelectionsToClipboard(list);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                IUImplementationGroup.this.copySelectionsToClipboard(list);
            }
        });
        copyItem.setText(JFaceResources.getString((String)"copy"));
        list.setMenu(copyMenu);
    }

    void copySelectionsToClipboard(List list) {
        StringBuffer buffer = new StringBuffer();
        String[] selections = list.getSelection();
        int i = 0;
        while (i < selections.length) {
            buffer.append(selections[i]);
            buffer.append("\n");
            ++i;
        }
        Clipboard clipboard = new Clipboard(list.getDisplay());
        clipboard.setContents(new Object[]{buffer.toString()}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }
}

