/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;

public class DotColorUtil {
    public String computeZestColor(String colorScheme, Color dotColor) {
        String javaFxColor = null;
        if (dotColor instanceof RGBColor) {
            RGBColor rgbColor = (RGBColor)dotColor;
            StringBuffer sb = new StringBuffer();
            sb.append("#");
            sb.append(rgbColor.getR());
            sb.append(rgbColor.getG());
            sb.append(rgbColor.getB());
            if (rgbColor.getA() != null) {
                sb.append(rgbColor.getA());
            }
            javaFxColor = sb.toString();
        } else if (dotColor instanceof HSVColor) {
            HSVColor hsvColor = (HSVColor)dotColor;
            javaFxColor = String.format("hsb(%s, %s%%, %s%%)", Double.parseDouble(hsvColor.getH()) * 360.0, Double.parseDouble(hsvColor.getS()) * 100.0, Double.parseDouble(hsvColor.getV()) * 100.0);
        } else if (dotColor instanceof StringColor) {
            StringColor stringColor = (StringColor)dotColor;
            String currentColorScheme = stringColor.getScheme();
            if (currentColorScheme == null) {
                currentColorScheme = colorScheme;
            }
            if (currentColorScheme == null || currentColorScheme.isEmpty()) {
                currentColorScheme = "x11";
            }
            String colorName = stringColor.getName();
            javaFxColor = DotColors.get((String)currentColorScheme, (String)colorName);
        }
        return javaFxColor;
    }
}

