/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.internal.util;

import java.util.Collection;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.PageBreakEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.PageBreaksFigure;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graphics.MapModeGraphics;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiagramPrinter
implements Runnable {
    protected org.eclipse.swt.graphics.Point display_dpi;
    protected Collection<Diagram> diagrams;
    protected PreferencesHint preferencesHint;
    protected IMapMode mapMode;
    protected org.eclipse.swt.graphics.Point translated;
    protected float userScale;
    protected boolean isScaledPercent = false;
    protected boolean fitToPage = false;
    protected boolean printRangePageSelection = false;
    protected int pageFrom = 1;
    protected int pageTo = 1;
    protected int rows = 1;
    protected int columns = 1;
    protected Graphics swtGraphics;
    protected Graphics graphics;

    public DiagramPrinter(PreferencesHint preferencesHint, IMapMode mm) {
        this.preferencesHint = preferencesHint;
        this.mapMode = mm;
    }

    protected Point getPageCount(DiagramEditPart dgrmEP, Rectangle figureBounds, Point pageSize, boolean applyUserScale) {
        RootEditPart rootEditPart = dgrmEP.getRoot();
        if (rootEditPart instanceof DiagramRootEditPart) {
            DiagramRootEditPart diagramRootEditPart = (DiagramRootEditPart)rootEditPart;
            PageBreakEditPart pageBreakEditPart = diagramRootEditPart.getPageBreakEditPart();
            float fNumCols = (float)((PageBreaksFigure)pageBreakEditPart.getFigure()).getPageCount().y * (applyUserScale ? this.userScale : 1.0f);
            float fNumRows = (float)((PageBreaksFigure)pageBreakEditPart.getFigure()).getPageCount().x * (applyUserScale ? this.userScale : 1.0f);
            int numCols = (int)Math.ceil(fNumCols);
            int numRows = (int)Math.ceil(fNumRows);
            return new Point(numCols, numRows);
        }
        float fNumRows = (float)figureBounds.height * (applyUserScale ? this.userScale : 1.0f) / (float)pageSize.y;
        int numRows = (int)Math.ceil(fNumRows);
        float fNumCols = (float)figureBounds.width * (applyUserScale ? this.userScale : 1.0f) / (float)pageSize.x;
        int numCols = (int)Math.ceil(fNumCols);
        return new Point(numCols, numRows);
    }

    protected int calculateRowFromPage(int pageNum, int totalNumColumns) {
        int row = pageNum / totalNumColumns;
        if (pageNum % totalNumColumns != 0) {
            ++row;
        }
        return row;
    }

    protected int calculateColumnFromPage(int pageNum, int totalNumColumns, int cRow) {
        return pageNum - (cRow - 1) * totalNumColumns;
    }

    protected void dispose() {
        block12: {
            if (this.graphics != null) {
                try {
                    try {
                        this.graphics.dispose();
                    }
                    catch (NullPointerException nullPointerException) {
                        this.graphics = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.graphics = null;
                    throw throwable;
                }
                this.graphics = null;
            }
        }
        if (this.swtGraphics != null) {
            try {
                try {
                    this.swtGraphics.dispose();
                }
                catch (NullPointerException nullPointerException) {
                    this.swtGraphics = null;
                }
            }
            finally {
                this.swtGraphics = null;
            }
        }
    }

    protected MapModeGraphics createMapModeGraphics(Graphics theGraphics) {
        return new MapModeGraphics(theGraphics, this.getMapMode());
    }

    public void setPrintRangePages(int pageFrom, int pageTo) {
        assert (pageFrom > 0) : "From page in print range page selection must be bigger than zero.";
        assert (pageTo > 0 && pageTo >= pageFrom) : "To page in print range page selection must be bigger than zero and from page.";
        this.pageFrom = pageFrom;
        this.pageTo = pageTo;
    }

    public org.eclipse.swt.graphics.Point getDisplayDPI() {
        return this.display_dpi;
    }

    public void setDisplayDPI(org.eclipse.swt.graphics.Point display_dpi) {
        this.display_dpi = display_dpi;
    }

    public PreferencesHint getPreferencesHint() {
        return this.preferencesHint;
    }

    public void setPreferencesHint(PreferencesHint preferencesHint) {
        this.preferencesHint = preferencesHint;
    }

    public IMapMode getMapMode() {
        return this.mapMode;
    }

    public void setMapMode(IMapMode mm) {
        this.mapMode = mm;
    }

    public org.eclipse.swt.graphics.Point getTranslated() {
        return this.translated;
    }

    public void setTranslated(org.eclipse.swt.graphics.Point translated) {
        this.translated = translated;
    }

    public float getUserScale() {
        return this.userScale;
    }

    public void setScaledPercent(int scalePercent) {
        this.isScaledPercent = true;
        this.userScale = (float)scalePercent / 100.0f;
    }

    public void setScaledPercent(boolean isScaledPercent) {
        this.isScaledPercent = isScaledPercent;
    }

    public boolean isFitToPage() {
        return this.fitToPage;
    }

    public void setFitToPage(boolean fitToPage) {
        this.fitToPage = fitToPage;
    }

    public boolean isPrintRangePageSelection() {
        return this.printRangePageSelection;
    }

    public void setPrintRangePageSelection(boolean printRangePageSelection) {
        this.printRangePageSelection = printRangePageSelection;
    }

    public int getPageFrom() {
        return this.pageFrom;
    }

    public void setPageFrom(int pageFrom) {
        this.pageFrom = pageFrom;
    }

    public int getPageTo() {
        return this.pageTo;
    }

    public void setPageTo(int pageTo) {
        this.pageTo = pageTo;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public Graphics getSwtGraphics() {
        return this.swtGraphics;
    }

    public void setSwtGraphics(Graphics swtGraphics) {
        this.swtGraphics = swtGraphics;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
    }

    public void setDiagrams(Collection<Diagram> diagrams) {
        this.diagrams = diagrams;
    }

    public Collection<Diagram> getDiagrams() {
        return this.diagrams;
    }
}

