/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;

public class VMCapabilitiesPropertyPage
extends PropertyPage {
    private List<ExpandableComposite> fExpandedComps = new ArrayList<ExpandableComposite>();
    private static final String EXPANDED_STATE = "vmc_expanded_state";
    private static Font fHeadingFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        ScrollPain scomp = new ScrollPain(parent);
        GridData gd = new GridData(1808);
        scomp.setLayout((Layout)new GridLayout());
        scomp.setLayoutData(gd);
        Composite comp = new Composite((Composite)scomp, 0);
        comp.setLayout((Layout)new GridLayout(2, true));
        gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        scomp.setContent((Control)comp);
        VirtualMachineImpl vm = this.getVM();
        if (vm == null) {
            this.setErrorMessage(PropertyPageMessages.VMCapabilitiesPropertyPage_0);
        } else {
            this.createExplanation(comp);
            SWTFactory.createVerticalSpacer((Composite)comp, (int)1);
            this.createHeadingLabel(comp, vm);
            SWTFactory.createVerticalSpacer((Composite)comp, (int)1);
            ExpandableComposite breakpoints = this.createExpandibleComposite(comp, 18, PropertyPageMessages.VMCapabilitiesPropertyPage_27, 2, 768);
            this.fExpandedComps.add(breakpoints);
            Composite bp_inner = SWTFactory.createComposite((Composite)breakpoints, (Font)comp.getFont(), (int)2, (int)2, (int)768);
            breakpoints.setClient((Control)bp_inner);
            this.createCapabilityEntry(bp_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_4, vm.canUseInstanceFilters());
            this.createCapabilityEntry(bp_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_9, vm.canWatchFieldModification());
            this.createCapabilityEntry(bp_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_10, vm.canWatchFieldAccess());
            this.createCapabilityEntry(bp_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_24, vm.canGetMethodReturnValues());
            this.createCapabilityEntry(bp_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_25, vm.canRequestMonitorEvents());
            ExpandableComposite hcr = this.createExpandibleComposite(comp, 18, PropertyPageMessages.VMCapabilitiesPropertyPage_28, 2, 768);
            this.fExpandedComps.add(hcr);
            Composite hcr_inner = SWTFactory.createComposite((Composite)hcr, (Font)comp.getFont(), (int)2, (int)2, (int)768);
            hcr.setClient((Control)hcr_inner);
            this.createCapabilityEntry(hcr_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_15, vm.canRedefineClasses());
            this.createCapabilityEntry(hcr_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_12, vm.canAddMethod());
            this.createCapabilityEntry(hcr_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_16, vm.canUnrestrictedlyRedefineClasses());
            ExpandableComposite stepping = this.createExpandibleComposite(comp, 18, PropertyPageMessages.VMCapabilitiesPropertyPage_29, 2, 768);
            this.fExpandedComps.add(stepping);
            Composite stepping_inner = SWTFactory.createComposite((Composite)stepping, (Font)comp.getFont(), (int)2, (int)2, (int)768);
            stepping.setClient((Control)stepping_inner);
            this.createCapabilityEntry(stepping_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_14, vm.canPopFrames());
            this.createCapabilityEntry(stepping_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_3, vm.canGetSyntheticAttribute());
            this.createCapabilityEntry(stepping_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_21, vm.canForceEarlyReturn());
            ExpandableComposite general = this.createExpandibleComposite(comp, 18, PropertyPageMessages.VMCapabilitiesPropertyPage_30, 2, 768);
            this.fExpandedComps.add(general);
            Composite general_inner = SWTFactory.createComposite((Composite)general, (Font)comp.getFont(), (int)2, (int)2, (int)768);
            general.setClient((Control)general_inner);
            this.createCapabilityEntry(general_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_6, vm.canGetCurrentContendedMonitor() && vm.canGetOwnedMonitorInfo());
            this.createCapabilityEntry(general_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_18, vm.canSetDefaultStratum());
            this.createCapabilityEntry(general_inner, PropertyPageMessages.VMCapabilitiesPropertyPage_26, vm.canGetInstanceInfo());
            this.restoreExpansionState();
        }
        this.applyDialogFont(comp);
        return comp;
    }

    private void createExplanation(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)2, (int)768);
        Label label = new Label(comp, 64);
        label.setFont(parent.getFont());
        label.setText(PropertyPageMessages.VMCapabilitiesPropertyPage_31);
        label.setLayoutData((Object)new GridData(768));
    }

    private void createHeadingLabel(Composite parent, VirtualMachineImpl vm) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)2, (int)32);
        SWTFactory.createLabel((Composite)comp, (String)PropertyPageMessages.VMCapabilitiesPropertyPage_1, (Font)fHeadingFont, (int)1);
        StringBuilder buff = new StringBuilder(vm.name().trim());
        buff = buff.append(" ").append(vm.version().trim());
        Text text = SWTFactory.createText((Composite)comp, (int)8, (int)1, (String)buff.toString());
        text.setBackground(parent.getBackground());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.VMCAPABILITIES_PROPERTY_PAGE);
    }

    private VirtualMachineImpl getVM() {
        IJavaDebugTarget dtarget;
        IAdaptable obj = this.getElement();
        IDebugTarget target = null;
        if (obj instanceof IDebugElement) {
            target = (IDebugTarget)((IDebugElement)obj).getAdapter(IDebugTarget.class);
        } else if (obj instanceof IProcess) {
            target = (IDebugTarget)((IProcess)obj).getAdapter(IDebugTarget.class);
        }
        if (target != null && !target.isTerminated() && !target.isDisconnected() && (dtarget = (IJavaDebugTarget)target.getAdapter(IJavaDebugTarget.class)) instanceof JDIDebugTarget) {
            return (VirtualMachineImpl)((JDIDebugTarget)target).getVM();
        }
        return null;
    }

    private void createCapabilityEntry(Composite parent, String label, boolean enabled) {
        SWTFactory.createCheckButton((Composite)parent, null, null, (boolean)enabled, (int)1).setEnabled(false);
        SWTFactory.createLabel((Composite)parent, (String)label, (Font)parent.getFont(), (int)1);
    }

    private ExpandableComposite createExpandibleComposite(Composite parent, int style, String label, int hspan, int fill) {
        ExpandableComposite ex = SWTFactory.createExpandibleComposite((Composite)parent, (int)style, (String)label, (int)hspan, (int)fill);
        ex.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ScrollPain sp = VMCapabilitiesPropertyPage.this.getParentScrollPane((Composite)((ExpandableComposite)e.getSource()));
                if (sp != null) {
                    sp.reflow(true);
                }
            }
        });
        return ex;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JDIDebugUIPlugin.getDefault().getPreferenceStore();
    }

    private void persistExpansionState() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            int i = 0;
            while (i < this.fExpandedComps.size()) {
                store.setValue(EXPANDED_STATE + i, this.fExpandedComps.get(i).isExpanded());
                ++i;
            }
        }
    }

    private void restoreExpansionState() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store == null) {
            this.fExpandedComps.get(0).setExpanded(true);
        } else {
            int i = 0;
            while (i < this.fExpandedComps.size()) {
                ExpandableComposite ex = this.fExpandedComps.get(i);
                ex.setExpanded(store.getBoolean(EXPANDED_STATE + i));
                ++i;
            }
        }
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        this.persistExpansionState();
        return ok;
    }

    private ScrollPain getParentScrollPane(Composite comp) {
        Composite parent = comp.getParent();
        while (parent != null && !(parent instanceof ScrollPain)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return (ScrollPain)parent;
        }
        return null;
    }

    class ScrollPain
    extends SharedScrolledComposite {
        public ScrollPain(Composite parent) {
            super(parent, 768);
            this.setExpandHorizontal(true);
            this.setExpandVertical(true);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
        }
    }
}

