/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.TransmitableArray;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IInvokable;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.REMInvokable;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

class REMInvokable
implements IInvokable {
    protected final IREMBeanTypeProxy beanType;
    protected final String methodName;
    protected final IBeanTypeProxy[] methodArgTypes;
    protected final REMProxyFactoryRegistry factory;

    REMInvokable(IREMBeanTypeProxy beanType, String methodName, IBeanTypeProxy[] methodArgTypes) {
        this.beanType = beanType;
        this.methodName = methodName;
        this.methodArgTypes = methodArgTypes;
        this.factory = (REMProxyFactoryRegistry)beanType.getProxyFactoryRegistry();
    }

    public IBeanProxy invoke(IBeanProxy subject) throws ThrowableProxy {
        return this.invoke(subject, (IBeanProxy[])null);
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy[] parms) throws ThrowableProxy {
        return this.invokeWithParms(subject, parms);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBeanProxy invokeWithParms(IBeanProxy subject, Object[] parms) throws ThrowableProxy {
        IREMConnection connect = this.factory.getFreeConnection();
        REMStandardBeanProxyFactory proxyFactory = (REMStandardBeanProxyFactory)this.factory.getBeanProxyFactory();
        proxyFactory.startTransaction();
        try {
            IBeanProxy iBeanProxy;
            Commands.ValueObject classValue = new Commands.ValueObject();
            this.beanType.renderBean(classValue);
            Commands.ValueObject parmTypesValue = new Commands.ValueObject();
            if (this.methodArgTypes != null) {
                class Retriever
                implements Commands.ValueRetrieve {
                    int index;
                    Object[] array;
                    Commands.ValueObject worker;
                    final /* synthetic */ REMInvokable this$0;

                    public Retriever(REMInvokable rEMInvokable, Object[] anArray) {
                        this.this$0 = rEMInvokable;
                        this.index = 0;
                        this.worker = new Commands.ValueObject();
                        this.array = anArray;
                    }

                    public Commands.ValueObject nextValue() {
                        Object parm = this.array[this.index++];
                        ((IREMBeanTypeProxy)parm).renderBean(this.worker);
                        return this.worker;
                    }
                }
                parmTypesValue.setArrayIDS(new Retriever(this, this.methodArgTypes), this.methodArgTypes.length, 22);
            }
            Commands.ValueObject subjectValue = new Commands.ValueObject();
            if (subject != null) {
                ((IREMBeanProxy)subject).renderBean(subjectValue);
            }
            Commands.ValueObject parmsValue = new Commands.ValueObject();
            if (parms != null) {
                IStandardBeanTypeProxyFactory typeFactory = this.factory.getBeanTypeProxyFactory();
                class Retriever
                implements Commands.ValueRetrieve {
                    int index;
                    Object[] array;
                    Commands.ValueObject worker;
                    final /* synthetic */ REMInvokable this$0;
                    private final /* synthetic */ IStandardBeanTypeProxyFactory val$typeFactory;

                    public Retriever(REMInvokable rEMInvokable, Object[] anArray, IStandardBeanTypeProxyFactory iStandardBeanTypeProxyFactory) {
                        this.this$0 = rEMInvokable;
                        this.val$typeFactory = iStandardBeanTypeProxyFactory;
                        this.index = 0;
                        this.worker = new Commands.ValueObject();
                        this.array = anArray;
                    }

                    public Commands.ValueObject nextValue() {
                        Object parm;
                        if ((parm = this.array[this.index++]) != null) {
                            if (parm instanceof IREMBeanProxy) {
                                ((IREMBeanProxy)parm).renderBean(this.worker);
                            } else if (parm instanceof TransmitableArray) {
                                this.worker.setArrayIDS(new Retriever(this.this$0, ((TransmitableArray)parm).array, this.val$typeFactory), ((TransmitableArray)parm).array.length, ((TransmitableArray)parm).componentTypeID);
                            } else {
                                IREMBeanProxy type = (IREMBeanProxy)((Object)this.val$typeFactory.getBeanTypeProxy(parm.getClass().getName()));
                                if (type == null) {
                                    throw new IllegalArgumentException();
                                }
                                int classID = type.getID();
                                this.worker.setAsObject(parm, classID);
                            }
                        } else {
                            this.worker.set();
                        }
                        return this.worker;
                    }
                }
                parmsValue.setArrayIDS(new Retriever(this, parms, typeFactory), parms.length, 23);
            }
            Commands.ValueObject returnValue = new Commands.ValueObject();
            try {
                this.invoke(connect, proxyFactory, classValue, parmTypesValue, subjectValue, parmsValue, returnValue);
                iBeanProxy = proxyFactory.getBeanProxy(returnValue);
            }
            catch (CommandException e) {
                IBeanProxy iBeanProxy2;
                if (e.isRecoverable()) {
                    ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                    Object var12_15 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return null;
                    this.factory.returnConnection(connect);
                    return null;
                }
                this.factory.closeConnection(connect);
                connect = null;
                connect = this.factory.getFreeConnection();
                try {
                    this.invoke(connect, proxyFactory, classValue, parmTypesValue, subjectValue, parmsValue, returnValue);
                    iBeanProxy2 = proxyFactory.getBeanProxy(returnValue);
                }
                catch (CommandException eAgain) {
                    this.factory.closeConnection(connect);
                    connect = null;
                    ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)eAgain));
                    Object var12_14 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return null;
                    this.factory.returnConnection(connect);
                    return null;
                }
                Object var12_13 = null;
                proxyFactory.stopTransaction();
                if (connect == null) return iBeanProxy2;
                this.factory.returnConnection(connect);
                return iBeanProxy2;
            }
            Object var12_12 = null;
            proxyFactory.stopTransaction();
            if (connect == null) return iBeanProxy;
            this.factory.returnConnection(connect);
            return iBeanProxy;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            proxyFactory.stopTransaction();
            if (connect == null) throw throwable;
            this.factory.returnConnection(connect);
            throw throwable;
        }
    }

    private void invoke(IREMConnection connect, REMStandardBeanProxyFactory proxyFactory, Commands.ValueObject classTypeValue, Commands.ValueObject parmTypesValue, Commands.ValueObject subjectValue, Commands.ValueObject parmsValue, Commands.ValueObject returnValue) throws ThrowableProxy, CommandException {
        try {
            connect.invokeMethod(classTypeValue, this.methodName, parmTypesValue, subjectValue, parmsValue, returnValue);
        }
        catch (CommandErrorException e) {
            proxyFactory.processErrorReturn(e);
        }
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy parm) throws ThrowableProxy {
        return this.invoke(subject, new IBeanProxy[]{parm});
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject) {
        try {
            return this.invoke(subject);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.factory.releaseProxy(e);
            return null;
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy[] parms) {
        try {
            return this.invoke(subject, parms);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.factory.releaseProxy(e);
            return null;
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy parm) {
        try {
            return this.invoke(subject, parm);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.factory.releaseProxy(e);
            return null;
        }
    }
}

