/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.internal.context.JpaValidator;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaEntity;
import org.eclipse.jpt.jpa.core.jpa2.context.Cacheable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCacheableReference2_0;
import org.eclipse.jpt.jpa.core.resource.java.EntityAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvertibleMapping;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkReadOnly;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaMultitenancy2_3;
import org.eclipse.jpt.jpa.eclipselink.core.internal.EclipseLinkJpaPlatformFactory;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.EclipseLinkEntityPrimaryKeyValidator;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.EclipseLinkTypeMappingValidator;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaCachingImpl;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaConverterContainerImpl;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaMultitenancyImpl2_3;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaReadOnly;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkNullJavaMultitenancy2_3;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ClassExtractorAnnotation2_1;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public class EclipseLinkJavaEntityImpl
extends AbstractJavaEntity
implements EclipseLinkJavaEntity,
EclipseLinkJavaConverterContainer.Parent {
    protected final EclipseLinkJavaCaching caching = this.buildCaching();
    protected final EclipseLinkJavaReadOnly readOnly = this.buildReadOnly();
    protected final EclipseLinkJavaConverterContainer converterContainer = this.buildConverterContainer();
    protected final EclipseLinkJavaChangeTracking changeTracking = this.buildChangeTracking();
    protected final EclipseLinkJavaCustomizer customizer = this.buildCustomizer();
    protected final EclipseLinkJavaMultitenancy2_3 multitenancy = this.buildMultitenancy();

    public EclipseLinkJavaEntityImpl(JavaPersistentType parent, EntityAnnotation mappingAnnotation) {
        super(parent, mappingAnnotation);
    }

    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.caching.synchronizeWithResourceModel(monitor);
        this.readOnly.synchronizeWithResourceModel(monitor);
        this.converterContainer.synchronizeWithResourceModel(monitor);
        this.changeTracking.synchronizeWithResourceModel(monitor);
        this.customizer.synchronizeWithResourceModel(monitor);
        this.multitenancy.synchronizeWithResourceModel(monitor);
    }

    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.caching.update(monitor);
        this.readOnly.update(monitor);
        this.converterContainer.update(monitor);
        this.changeTracking.update(monitor);
        this.customizer.update(monitor);
        this.multitenancy.update(monitor);
    }

    @Override
    public EclipseLinkJavaCaching getCaching() {
        return this.caching;
    }

    protected EclipseLinkJavaCaching buildCaching() {
        return new EclipseLinkJavaCachingImpl(this);
    }

    @Override
    public EclipseLinkReadOnly getReadOnly() {
        return this.readOnly;
    }

    protected EclipseLinkJavaReadOnly buildReadOnly() {
        return new EclipseLinkJavaReadOnly(this);
    }

    @Override
    public EclipseLinkJavaConverterContainer getConverterContainer() {
        return this.converterContainer;
    }

    protected EclipseLinkJavaConverterContainer buildConverterContainer() {
        return new EclipseLinkJavaConverterContainerImpl(this);
    }

    @Override
    public Iterable<EclipseLinkConverter> getConverters() {
        return IterableTools.concatenate((Iterable[])new Iterable[]{this.converterContainer.getConverters(), this.getAttributeMappingConverters()});
    }

    protected Iterable<EclipseLinkConverter> getAttributeMappingConverters() {
        return IterableTools.removeNulls(this.getAttributeMappingConverters_());
    }

    protected Iterable<EclipseLinkConverter> getAttributeMappingConverters_() {
        return IterableTools.children((Iterable)this.getAttributeMappings(), EclipseLinkConvertibleMapping.ATTRIBUTE_MAPPING_CONVERTERS_TRANSFORMER);
    }

    @Override
    public EclipseLinkChangeTracking getChangeTracking() {
        return this.changeTracking;
    }

    protected EclipseLinkJavaChangeTracking buildChangeTracking() {
        return new EclipseLinkJavaChangeTracking(this);
    }

    @Override
    public EclipseLinkCustomizer getCustomizer() {
        return this.customizer;
    }

    protected EclipseLinkJavaCustomizer buildCustomizer() {
        return new EclipseLinkJavaCustomizer(this);
    }

    @Override
    public EclipseLinkJavaMultitenancy2_3 getMultitenancy() {
        return this.multitenancy;
    }

    protected EclipseLinkJavaMultitenancy2_3 buildMultitenancy() {
        return this.isEclipseLink2_3Compatible() ? new EclipseLinkJavaMultitenancyImpl2_3(this) : new EclipseLinkNullJavaMultitenancy2_3(this);
    }

    protected boolean isEclipseLink2_3Compatible() {
        return this.getJpaPlatformVersion().isCompatibleWithEclipseLinkVersion("2.3");
    }

    protected EclipseLinkJpaPlatformFactory.EclipseLinkJpaPlatformVersion getJpaPlatformVersion() {
        return (EclipseLinkJpaPlatformFactory.EclipseLinkJpaPlatformVersion)super.getJpaPlatformVersion();
    }

    @Override
    public boolean isMultitenantMetadataAllowed() {
        return this.isRootEntity() || this.isInheritanceStrategyTablePerClass();
    }

    protected boolean isInheritanceStrategyTablePerClass() {
        return this.getInheritanceStrategy() == InheritanceType.TABLE_PER_CLASS;
    }

    protected boolean buildSpecifiedDiscriminatorColumnIsAllowed() {
        return super.buildSpecifiedDiscriminatorColumnIsAllowed() && !this.classExtractorIsSpecified();
    }

    protected boolean classExtractorIsSpecified() {
        return this.getClassExtractorAnnotation() != null;
    }

    protected ClassExtractorAnnotation2_1 getClassExtractorAnnotation() {
        return (ClassExtractorAnnotation2_1)this.getJavaResourceType().getAnnotation("org.eclipse.persistence.annotations.ClassExtractor");
    }

    @Override
    public boolean usesPrimaryKeyColumns() {
        return this.getJavaResourceType().getAnnotation("org.eclipse.persistence.annotations.PrimaryKey") != null;
    }

    @Override
    public boolean usesPrimaryKeyTenantDiscriminatorColumns() {
        return this.getMultitenancy().usesPrimaryKeyTenantDiscriminatorColumns();
    }

    public Cacheable2_0 getCacheable() {
        return ((JavaCacheableReference2_0)this.getCaching()).getCacheable();
    }

    public boolean calculateDefaultCacheable() {
        return ((JavaCacheableReference2_0)this.getCaching()).calculateDefaultCacheable();
    }

    @Override
    public JavaResourceAnnotatedElement getJavaResourceAnnotatedElement() {
        return this.getJavaResourceType();
    }

    @Override
    public boolean supportsConverters() {
        return true;
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.multitenancy.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.caching.validate(messages, reporter);
        this.readOnly.validate(messages, reporter);
        this.converterContainer.validate(messages, reporter);
        this.changeTracking.validate(messages, reporter);
        this.customizer.validate(messages, reporter);
        this.multitenancy.validate(messages, reporter);
    }

    protected JpaValidator buildPrimaryKeyValidator() {
        return new EclipseLinkEntityPrimaryKeyValidator(this);
    }

    protected JpaValidator buildTypeMappingValidator() {
        return new EclipseLinkTypeMappingValidator(this);
    }
}

