/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.SignatureBasedType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.internal.util.IObjectSymbolBasedValueType;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.el.AbstractDTPropertyResolver;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.MemberAccessorOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.Messages;

public class BracketOperator
extends MemberAccessorOperator {
    private static final String OPERATOR_NAME_ARRAY_ACCESSOR = "array ('[]') accessor";

    public BracketOperator(DiagnosticFactory diagnosticFactory, IFile file, ISymbolContextResolver resolver) {
        super(file, diagnosticFactory, resolver);
    }

    protected SignatureBasedType handlePerformObjectSymbolValue(IObjectSymbolBasedValueType firstArg, ValueType secondArg) {
        if (firstArg.isInstanceOf("Ljava.util.List;") || Signature.getArrayCount((String)firstArg.getSignature()) > 0) {
            return this.handlePerformNumericPropertyAccessorBase(firstArg, secondArg);
        }
        if (secondArg instanceof LiteralType) {
            return this.handlePerformNamedPropertyAccessorBase(firstArg, (LiteralType)secondArg);
        }
        return null;
    }

    protected Diagnostic validateObjectSymbolValue(IObjectSymbolBasedValueType firstArg, ValueType secondArg) {
        if (firstArg.isInstanceOf("Ljava.util.List;") || firstArg.getSymbol().getTypeDescriptor().isArray()) {
            return this.validateNumericPropertyAccessorBase(firstArg, secondArg);
        }
        if (secondArg instanceof LiteralType) {
            return this.validateNamedPropertyAccessorBase(firstArg, (LiteralType)secondArg);
        }
        return Diagnostic.OK_INSTANCE;
    }

    private Diagnostic validateNumericPropertyAccessorBase(IObjectSymbolBasedValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            if (secondArg instanceof LiteralType) {
                Integer integerValue = (Integer)((LiteralType)secondArg).coerceToNumber(Integer.class);
                if (integerValue < 0) {
                    return this._diagnosticFactory.create_POSSIBLE_ARRAY_INDEX_OUT_OF_BOUNDS(integerValue);
                }
            } else if (TypeCoercer.typeIsString((String)secondArg.getSignature())) {
                return this._diagnosticFactory.create_UNARY_OP_STRING_CONVERSION_NOT_GUARANTEED(OPERATOR_NAME_ARRAY_ACCESSOR);
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return this._diagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION(OPERATOR_NAME_ARRAY_ACCESSOR);
        }
    }

    private SignatureBasedType handlePerformNumericPropertyAccessorBase(IObjectSymbolBasedValueType firstArg, ValueType secondArg) {
        ISymbol symbol;
        AbstractDTPropertyResolver propResolver = this.getPropertyResolver();
        int index = 0;
        if (secondArg instanceof LiteralType) {
            try {
                index = ((LiteralType)secondArg).coerceToNumber(Integer.class).intValue();
            }
            catch (TypeCoercionException typeCoercionException) {}
        }
        if ((symbol = propResolver.getProperty((ISymbol)firstArg.getSymbol(), index)) instanceof IObjectSymbol) {
            return IObjectSymbolBasedValueType.getInstance((ISymbol)symbol);
        }
        return null;
    }

    protected String getOperatorName() {
        return Messages.getString("BracketOperator.Name");
    }

    private AbstractDTPropertyResolver getPropertyResolver() {
        DesignTimeApplicationManager manager = DesignTimeApplicationManager.getInstance(this._file.getProject());
        if (manager != null) {
            return manager.getPropertyResolver();
        }
        return null;
    }
}

