/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.Iterator;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

public class SpecTreeTraverser
extends TreeTraverser {
    public SpecTreeTraverser(INodePO rootNode, ITreeNodeOperation<INodePO> operation) {
        super(rootNode, operation);
    }

    @Override
    protected void traverseImpl(ITreeTraverserContext<INodePO> context, INodePO parent, INodePO node) {
        context.append(node);
        if (context.isContinue()) {
            Iterator<INodePO> iter;
            for (ITreeNodeOperation<INodePO> operation : this.getOperations()) {
                operation.operate(context, parent, node, false);
            }
            if (node instanceof IProjectPO) {
                IProjectPO project = (IProjectPO)node;
                for (INodePO specPers : project.getUnmodSpecList()) {
                    this.traverseImpl(context, project, specPers);
                }
            } else if (node instanceof ICategoryPO) {
                ICategoryPO catPO = (ICategoryPO)node;
                iter = catPO.getNodeListIterator();
                while (iter.hasNext()) {
                    INodePO next = iter.next();
                    this.traverseImpl(context, catPO, next);
                }
            } else if (node instanceof ISpecTestCasePO) {
                ISpecTestCasePO specTC = (ISpecTestCasePO)node;
                iter = specTC.getNodeListIterator();
                while (iter.hasNext()) {
                    this.traverseImpl(context, specTC, iter.next());
                }
                iter = specTC.getAllEventEventExecTC().iterator();
                while (iter.hasNext()) {
                    this.traverseImpl(context, specTC, iter.next());
                }
            }
            for (ITreeNodeOperation<INodePO> operation : this.getOperations()) {
                operation.postOperate(context, parent, node, false);
            }
        }
        context.removeLast();
    }
}

