/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.treeoperations.CheckIfCAPisDeprecated;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.NodeNameUtil;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractQuery;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.osgi.util.NLS;

public class DeprecatedModulesQuery
extends AbstractQuery {
    public DeprecatedModulesQuery() {
        super(null);
    }

    public IStatus run(IProgressMonitor monitor) {
        this.setMonitor(monitor);
        ArrayList deprecatedModules = new ArrayList();
        IProjectPO currentProject = GeneralStorage.getInstance().getProject();
        CheckIfCAPisDeprecated op = new CheckIfCAPisDeprecated();
        TreeTraverser traverser = new TreeTraverser((INodePO)currentProject, (ITreeNodeOperation)op, true, true);
        traverser.traverse(true);
        Set deprecatedNodes = op.getDeprecatedNodes();
        for (INodePO iNodePO : deprecatedNodes) {
            String parentName = "";
            INodePO parentNode = iNodePO.getSpecAncestor();
            if (parentNode == null) {
                parentNode = iNodePO.getParentNode();
            }
            if (parentNode != null) {
                parentName = parentNode.getName();
            }
            String nodeName = iNodePO.getName();
            if (iNodePO instanceof IExecTestCasePO) {
                nodeName = NodeNameUtil.getText((IExecTestCasePO)((IExecTestCasePO)iNodePO), (boolean)false);
            }
            deprecatedModules.add(new BasicSearchResult.SearchResultElement<Long>(NLS.bind((String)Messages.SearchResultPageElementLabel, (Object[])new Object[]{parentName, nodeName}), iNodePO.getId(), GeneralLabelProvider.getImageImpl(iNodePO), new BasicSearchResult.NodeSearchResultElementAction(), iNodePO.getComment()));
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.setSearchResult(deprecatedModules);
        monitor.done();
        return Status.OK_STATUS;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTimestamp());
        sb.append(":");
        sb.append(" ");
        sb.append(Messages.UIJobSearchingDeprecatedModules);
        return sb.toString();
    }
}

