/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views.logview;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.ui.views.ContextBasedView;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.NonSortedPropertySheetPage;
import org.eclipse.jubula.client.ui.views.logview.LogProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class LogView
extends ContextBasedView
implements IJBPart,
ISelectionProvider {
    public static final String VIEW_ID = "org.eclipse.jubula.client.ui.views.Log";
    private ScrolledComposite m_scrollComposite;
    private Composite m_child;
    private Text m_logWidget;
    private String m_commandLog;
    private ISelection m_currSelection = null;

    public LogView() {
        super("org.eclipse.jubula.client.ui.contexts.LogViewDisplaysLog");
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        parent.setLayout((Layout)new FillLayout());
        this.m_scrollComposite = new ScrolledComposite(parent, 768);
        this.m_child = new Composite((Composite)this.m_scrollComposite, 0);
        this.m_child.setLayout((Layout)new FillLayout());
        this.m_logWidget = new Text(this.m_child, 2818);
        this.m_logWidget.setEditable(false);
        this.m_scrollComposite.setExpandHorizontal(true);
        this.m_scrollComposite.setExpandVertical(true);
        this.m_scrollComposite.setMinSize(this.m_child.computeSize(-1, -1));
        this.m_scrollComposite.setContent((Control)this.m_child);
        MenuManager contextManager = new MenuManager();
        contextManager.setRemoveAllWhenShown(true);
        Menu contextMenu = contextManager.createContextMenu((Control)this.m_logWidget);
        this.m_logWidget.setMenu(contextMenu);
        this.getSite().registerContextMenu(contextManager, (ISelectionProvider)this);
        super.createPartControl(parent);
        this.handleSelection(this.getSelectionService().getSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void setFocus() {
        this.m_logWidget.setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return this.m_currSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    @Override
    protected void handleSelection(ISelection selection) {
        IStructuredSelection ss;
        LogProvider provider = null;
        if (selection != null && selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() > 0) {
            Object object = ss.getFirstElement();
            if (this.m_currSelection != null && ObjectUtils.equals((Object)object, (Object)((IStructuredSelection)this.m_currSelection).getFirstElement())) {
                return;
            }
            this.m_currSelection = ss;
            provider = (LogProvider)Platform.getAdapterManager().getAdapter(object, LogProvider.class);
        }
        if (provider != null) {
            this.handleSelection(provider);
        }
    }

    private void handleSelection(LogProvider provider) {
        String string = provider.getLogString();
        String newline = "\n";
        String systemNewLine = System.getProperty("line.separator");
        if (StringUtils.isNotBlank((String)string)) {
            if (!newline.equals(systemNewLine)) {
                string = string.replace(newline, systemNewLine);
            }
            this.m_commandLog = string;
            this.m_logWidget.setText(this.m_commandLog);
            this.m_logWidget.setEnabled(true);
            this.setStatusOfContext(true);
            this.m_logWidget.redraw();
        } else {
            this.m_commandLog = "";
            this.m_logWidget.setText(this.m_commandLog);
            this.m_logWidget.setEnabled(false);
            this.setStatusOfContext(false);
        }
    }

    @Override
    public void dispose() {
        if (this.m_logWidget != null || !this.m_logWidget.isDisposed()) {
            this.m_logWidget.dispose();
        }
        super.dispose();
    }

    public String getCommandLog() {
        return this.m_commandLog;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return new NonSortedPropertySheetPage();
        }
        return super.getAdapter(key);
    }
}

