/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.awt.Rectangle;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.CheckWithTimeoutQueuer;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeNodeTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.AbstractTreeTableOperationContext;
import org.eclipse.jubula.rc.common.implclasses.tree.ExpandCollapseTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.INodePath;
import org.eclipse.jubula.rc.common.implclasses.tree.PathBasedTraverser;
import org.eclipse.jubula.rc.common.implclasses.tree.SelectTreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperation;
import org.eclipse.jubula.rc.common.implclasses.tree.TreeNodeOperationConstraint;
import org.eclipse.jubula.rc.common.tester.AbstractTreeTester;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITreeTableComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.common.util.Verifier;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public abstract class AbstractTreeTableTester
extends AbstractTreeTester {
    public void rcCheckExistenceOfColumn(final String column, final String columnOperator, final boolean exists, int timeout) {
        CheckWithTimeoutQueuer.invokeAndWait("rcCheckExistenceOfColumn", timeout, new Runnable(){

            public void run() {
                AbstractTreeTableTester.this.checkExistenceOfColumn(column, columnOperator, exists);
            }
        });
    }

    public void rcSelect(String pathType, int preAscend, String treePath, String operator, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex(column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void rcSelectByIndices(String pathType, int preAscend, String indexPath, int clickCount, int column, int button) throws StepExecutionException {
        int implCol = IndexConverter.toImplementationIndex(column);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void rcVerifySelectedValue(final String pattern, final int column, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcVerifySelectedValue", timeout, new Runnable(){

            public void run() {
                AbstractTreeTableTester.this.rcVerifySelectedValue(pattern, MatchUtil.DEFAULT_OPERATOR, column);
            }
        });
    }

    public void rcVerifySelectedValue(final String pattern, final String operator, final int column, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcVerifySelectedValue", timeout, new Runnable(){

            public void run() {
                int implCol = IndexConverter.toImplementationIndex(column);
                AbstractTreeTableTester.this.checkColumnIndex(implCol);
                Verifier.match(AbstractTreeTableTester.this.getRenderedTextOfColumn(implCol), pattern, operator);
            }
        });
    }

    protected void checkColumnIndex(int index) throws StepExecutionException {
        final AbstractTreeTableOperationContext context = this.getTreeTableAdapter().getContext(0);
        int numColumns = this.getEventThreadQueuer().invokeAndWait("checkColumnIndex", new IRunnable<Integer>(){

            @Override
            public Integer run() {
                return new Integer(context.getNumberOfColumns());
            }
        });
        if (index < 0 || index >= numColumns) {
            throw new StepExecutionException("Invalid column: " + IndexConverter.toUserIndex(index), EventFactory.createActionError((String)"TestErrorEvent.InvalidIndex"));
        }
    }

    protected void checkExistenceOfColumn(String column, String columnOperator, boolean exists) {
        Rectangle bounds;
        int index;
        AbstractTreeTableOperationContext context;
        block3: {
            context = this.getTreeTableAdapter().getContext(0);
            index = -2;
            try {
                index = context.getColumnFromString(column, columnOperator, true);
            }
            catch (StepExecutionException see) {
                if (!exists) break block3;
                throw see;
            }
        }
        if (index >= 0 && ((bounds = context.getHeaderBounds(index)) == null || bounds.getWidth() <= 0.0)) {
            index = -2;
        }
        Verifier.equals(exists, index >= 0);
    }

    protected String getRenderedTextOfColumn(int column) throws StepExecutionException {
        AbstractTreeTableOperationContext context = this.getTreeTableAdapter().getContext(column);
        return context.getRenderedTextOfColumn(context.getSelectedNode());
    }

    protected ITreeTableComponent getTreeTableAdapter() {
        return (ITreeTableComponent)this.getComponent();
    }

    protected void selectByPath(String pathType, int preAscend, INodePath objectPath, ClickOptions co, int column) {
        ExpandCollapseTreeNodeOperation expOp = new ExpandCollapseTreeNodeOperation(false);
        SelectTreeNodeOperation selectOp = new SelectTreeNodeOperation(co);
        INodePath subPath = objectPath.subPath(0, objectPath.getLength() - 1);
        this.traverseTreeByPath(subPath, pathType, preAscend, expOp);
        this.traverseLastElementByPath(objectPath, pathType, preAscend, selectOp, column);
    }

    protected void traverseLastElementByPath(INodePath treePath, String pathType, int preAscend, TreeNodeOperation operation, int column) throws StepExecutionException {
        Validate.notNull((Object)treePath);
        Validate.notNull((Object)operation);
        AbstractTreeTableOperationContext context = this.getTreeTableAdapter().getContext(column);
        PathBasedTraverser traverser = new PathBasedTraverser(context, treePath, new TreeNodeOperationConstraint());
        ((AbstractTreeNodeTraverser)traverser).traversePath(operation, this.getStartNode(pathType, preAscend, context));
    }

    public void rcSelectByColumnPath(String pathType, int preAscend, String indexPath, int clickCount, String column, String operator, int button) throws StepExecutionException {
        int implCol = this.getTreeTableAdapter().getContext(0).getColumnFromString(column, operator, true);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createIndexNodePath(this.splitIndexTreePath(indexPath)), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void rcSelectColumnPath(String pathType, int preAscend, String treePath, String operator, int clickCount, String column, String colOperator, int button) throws StepExecutionException {
        int implCol = this.getTreeTableAdapter().getContext(0).getColumnFromString(column, colOperator, true);
        this.checkColumnIndex(implCol);
        this.selectByPath(pathType, preAscend, this.createStringNodePath(this.splitTextTreePath(treePath), operator), ClickOptions.create().setClickCount(clickCount).setMouseButton(button), implCol);
    }

    public void rcVerifySelectedValueAtPath(final String pattern, final String operator, final String column, final String colOperator, int timeout) throws StepExecutionException {
        CheckWithTimeoutQueuer.invokeAndWait("rcVerifySelectedValueAtPath", timeout, new Runnable(){

            public void run() {
                AbstractTreeTableOperationContext context = AbstractTreeTableTester.this.getTreeTableAdapter().getContext(0);
                int implCol = context.getColumnFromString(column, colOperator, true);
                AbstractTreeTableTester.this.checkColumnIndex(implCol);
                context.setColumn(implCol);
                String text = context.getRenderedTextOfColumn(context.getSelectedNode());
                Verifier.match(text, pattern, operator);
            }
        });
    }
}

