/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.util;

import java.awt.Point;
import java.awt.Rectangle;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;

public class PointUtil {
    protected PointUtil() {
    }

    public static Point calculateAwtPointToGo(int xPos, boolean xAbsolute, int yPos, boolean yAbsolute, Rectangle constraints) {
        Point pointToGo = new Point(constraints.x, constraints.y);
        if (xAbsolute) {
            pointToGo.x += xPos;
        } else {
            int x = (int)((double)constraints.width / 100.0 * (double)xPos);
            pointToGo.x += x;
        }
        if (yAbsolute) {
            pointToGo.y += yPos;
        } else {
            int y = (int)((double)constraints.height / 100.0 * (double)yPos);
            pointToGo.y += y;
        }
        pointToGo = PointUtil.adjustPointToGo(pointToGo, constraints);
        if (!constraints.contains(pointToGo)) {
            throw new StepExecutionException("TestErrorEvent.ClickPointInvalid", EventFactory.createActionError((String)"TestErrorEvent.ClickPointInvalid"));
        }
        return pointToGo;
    }

    public static Rectangle stringAsRectangle(String sRectangle) {
        String[] aBounds = StringUtils.split((String)sRectangle, (char)':');
        if (aBounds.length != 4) {
            throw new IllegalArgumentException("non-well formatted sRectangle: " + sRectangle);
        }
        int x = Integer.valueOf(aBounds[0]);
        int y = Integer.valueOf(aBounds[1]);
        int width = Integer.valueOf(aBounds[2]);
        int height = Integer.valueOf(aBounds[3]);
        return new Rectangle(x, y, width, height);
    }

    private static Point adjustPointToGo(Point pointToGo, Rectangle widgetBounds) {
        int x = widgetBounds.x + widgetBounds.width;
        int y = widgetBounds.y + widgetBounds.height;
        if (pointToGo.x == x) {
            --pointToGo.x;
        }
        if (pointToGo.y == y) {
            --pointToGo.y;
        }
        if (pointToGo.x == widgetBounds.x) {
            ++pointToGo.x;
        }
        if (pointToGo.y == widgetBounds.y) {
            ++pointToGo.y;
        }
        return pointToGo;
    }
}

