/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jwt.transformations.api.AbstractTypeSafeTransformation;
import org.eclipse.jwt.transformations.api.Transformation;
import org.eclipse.jwt.transformations.api.TransformationException;
import org.eclipse.jwt.transformations.api.io.AbstractIODefinition;
import org.eclipse.jwt.transformations.api.io.IODefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class TransformationService
extends AbstractTypeSafeTransformation<String, String> {
    private static final String JWT_DEFAULT_IODEFS_PREFIX = "org.eclipse.jwt.transformations.iodefinitions.default";
    private static final String DEFAULT_EXPORT_INPUT_WORKSPACE = "org.eclipse.jwt.transformations.iodefinitions.default.export.input.workspace";
    private static final String DEFAULT_EXPORT_OUTPUT_WORKSPACE = "org.eclipse.jwt.transformations.iodefinitions.default.export.output.workspace";
    private static final String DEFAULT_IMPORT_INPUT_WORKSPACE = "org.eclipse.jwt.transformations.iodefinitions.default.import.input.workspace";
    private static final String DEFAULT_IMPORT_OUTPUT_WORKSPACE = "org.eclipse.jwt.transformations.iodefinitions.default.import.output.workspace";
    private static final String DEFAULT_EXPORT_INPUT_LOCAL = "org.eclipse.jwt.transformations.iodefinitions.default.export.input.local";
    private static final String DEFAULT_IMPORT_INPUT_LOCAL = "org.eclipse.jwt.transformations.iodefinitions.default.import.input.local";
    private static final String DEFAULT_EXPORT_OUTPUT_LOCAL = "org.eclipse.jwt.transformations.iodefinitions.default.export.output.local";
    private static final String DEFAULT_IMPORT_OUTPUT_LOCAL = "org.eclipse.jwt.transformations.iodefinitions.default.import.output.local";

    @Deprecated
    public abstract void transform(String var1, String var2) throws IOException, TransformationException;

    @Deprecated
    public void setType(String type) {
        this.setType(Transformation.Type.fromString(type));
    }

    @Deprecated
    public String getTye() {
        return this.getType().toString();
    }

    private static String extractPath(Object file) {
        if (file instanceof File) {
            return ((File)file).getPath();
        }
        if (file instanceof IFile) {
            return ((IFile)file).getRawLocationURI().getPath();
        }
        return (String)file;
    }

    @Override
    protected final String getInput(Object rawInput) throws ClassCastException {
        return TransformationService.extractPath(rawInput);
    }

    @Override
    protected final String getOutput(Object rawOutput) throws ClassCastException, IOException {
        String path = TransformationService.extractPath(rawOutput);
        File destFile = new File(path);
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        return path;
    }

    @Override
    protected final void doTransform(String input, String output) throws TransformationException, IOException {
        this.transform(input, output);
    }

    private static IODefinition createIODefinition(String extensionID) {
        try {
            return AbstractIODefinition.createIODefinition(extensionID);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final List<IODefinition> getCompatibleInputDefinitions() {
        List<IODefinition> result = super.getCompatibleInputDefinitions();
        if (result.isEmpty()) {
            result = new ArrayList<IODefinition>();
            switch (this.getType()) {
                case EXPORT: {
                    result.add(TransformationService.createIODefinition(DEFAULT_EXPORT_INPUT_LOCAL));
                    result.add(TransformationService.createIODefinition(DEFAULT_EXPORT_INPUT_WORKSPACE));
                    break;
                }
                case IMPORT: {
                    result.add(TransformationService.createIODefinition(DEFAULT_IMPORT_INPUT_LOCAL));
                    result.add(TransformationService.createIODefinition(DEFAULT_IMPORT_INPUT_WORKSPACE));
                }
            }
        }
        return result;
    }

    @Override
    public final List<IODefinition> getCompatibleOutputDefinitions() {
        List<IODefinition> result = super.getCompatibleInputDefinitions();
        if (result.isEmpty()) {
            result = new ArrayList<IODefinition>();
            switch (this.getType()) {
                case EXPORT: {
                    result.add(TransformationService.createIODefinition(DEFAULT_EXPORT_OUTPUT_LOCAL));
                    result.add(TransformationService.createIODefinition(DEFAULT_EXPORT_OUTPUT_WORKSPACE));
                    break;
                }
                case IMPORT: {
                    result.add(TransformationService.createIODefinition(DEFAULT_IMPORT_OUTPUT_LOCAL));
                    result.add(TransformationService.createIODefinition(DEFAULT_IMPORT_OUTPUT_WORKSPACE));
                }
            }
        }
        return result;
    }
}

