/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.plugins.viewbpmn.palette;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jwt.meta.model.events.EventsPackage;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.figures.internal.ImageFactory;
import org.eclipse.jwt.we.figures.internal.ScalingImageDescriptor;
import org.eclipse.jwt.we.misc.factories.EcoreFactory;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.misc.views.Views;
import org.eclipse.jwt.we.plugins.viewbpmn.BPMNViewPluginProperties;
import org.eclipse.swt.graphics.Image;

public class Palette
extends PaletteRoot {
    public static final Dimension ICON_SMALL_SIZE = ImageFactory.MODEL_TYPE_IMAGE_SIZE;
    public static final Dimension ICON_LARGE_SIZE = new Dimension(24, 24);
    private static final Logger logger = Logger.getLogger(Palette.class);

    public Palette(WEEditor editor) {
        PaletteDrawer activityGroup = null;
        PaletteGroup palette = new PaletteGroup("BPMN Editor");
        palette.add((PaletteEntry)new PanningSelectionToolEntry());
        if (activityGroup == null) {
            activityGroup = new PaletteDrawer(BPMNViewPluginProperties.palette_ActivityElementsGroups_name);
        }
        logger.info("Palette building for selected View = " + Views.getInstance().getSelectedView().getInternalName());
        logger.info("in properties selected view = " + BPMNViewPluginProperties.view_BPMN_name);
        activityGroup.add((PaletteEntry)this.createCreationToolEntry(ProcessesPackage.Literals.ACTION));
        activityGroup.add((PaletteEntry)this.createCreationToolEntry(ProcessesPackage.Literals.INITIAL_NODE));
        activityGroup.add((PaletteEntry)this.createCreationToolEntry(ProcessesPackage.Literals.FINAL_NODE));
        activityGroup.add((PaletteEntry)this.createCreationToolEntry(ProcessesPackage.Literals.FORK_NODE));
        activityGroup.add((PaletteEntry)this.createCreationToolEntry(ProcessesPackage.Literals.DECISION_NODE));
        activityGroup.add((PaletteEntry)new PaletteSeparator());
        activityGroup.add((PaletteEntry)this.createCreationToolEntry(EventsPackage.Literals.EVENT));
        activityGroup.add((PaletteEntry)new PaletteSeparator());
        activityGroup.add((PaletteEntry)this.createConnectionCreationToolEntry(ProcessesPackage.Literals.ACTIVITY_EDGE));
        palette.add((PaletteEntry)activityGroup);
        this.add((PaletteEntry)palette);
    }

    public ToolEntry createCreationToolEntry(EClass modelType) {
        EcoreFactory factory = new EcoreFactory(modelType);
        ImageDescriptor smallIcon = Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[]{Views.getInstance().getSelectedView()}).createImageDescriptor(BPMNViewPluginProperties.model_smallIcon(modelType));
        smallIcon = new ScalingImageDescriptor(smallIcon, ICON_SMALL_SIZE);
        ImageDescriptor largeIcon = Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[]{Views.getInstance().getSelectedView()}).createImageDescriptor(BPMNViewPluginProperties.model_smallIcon(modelType));
        largeIcon = new ScalingImageDescriptor(largeIcon, ICON_LARGE_SIZE);
        if (!this.createsValidImage(smallIcon)) {
            smallIcon = null;
        }
        if (!this.createsValidImage(largeIcon)) {
            largeIcon = null;
        }
        return new CombinedTemplateCreationEntry(BPMNViewPluginProperties.palette_CreationEntry_name(modelType), BPMNViewPluginProperties.palette_CreationEntry_description(modelType), (Object)factory, (CreationFactory)factory, smallIcon, largeIcon);
    }

    public boolean createsValidImage(ImageDescriptor imageDescriptor) {
        boolean result = false;
        Image image = imageDescriptor.createImage(false);
        if (image != null) {
            image.dispose();
            result = true;
        }
        return result;
    }

    public ToolEntry createConnectionCreationToolEntry(EClass modelType) {
        EcoreFactory factory = new EcoreFactory(modelType);
        return new ConnectionCreationToolEntry(BPMNViewPluginProperties.palette_CreationEntry_name(modelType), BPMNViewPluginProperties.palette_CreationEntry_description(modelType), (CreationFactory)factory, Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[]{Views.getInstance().getSelectedView()}).createImageDescriptor(BPMNViewPluginProperties.model_smallIcon(modelType)), Plugin.getInstance().getFactoryRegistry().getImageFactory(new Object[]{Views.getInstance().getSelectedView()}).createImageDescriptor(BPMNViewPluginProperties.model_largeIcon(modelType)));
    }
}

