/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.outline;

import java.util.ArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.outline.ModelOutlineAreaOverview;
import org.eclipse.jwt.we.editors.outline.ModelOutlineAreaTreeviewer;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class ModelOutlinePage
extends ContentOutlinePage
implements IDoubleClickListener {
    private WEEditor editor;
    private MenuManager contextMenuManager;
    private SashForm mainArea;
    private ModelOutlineAreaOverview overviewOutlineArea;
    private ModelOutlineAreaTreeviewer treeviewerOutlineArea;
    public String current_display_mode = "";
    public static String OUTLINE_AREA_OVERVIEW = "outlinearea_overview";
    public static String OUTLINE_AREA_TREEVIEW = "outlinearea_treeview";
    public static String OUTLINE_AREA_BOTH = "outlinearea_both";

    public ModelOutlinePage(WEEditor editor) {
        assert (editor != null);
        this.editor = editor;
    }

    public MenuManager getContextMenuManager() {
        if (this.contextMenuManager == null) {
            this.contextMenuManager = new MenuManager();
            this.contextMenuManager.setRemoveAllWhenShown(true);
        }
        return this.contextMenuManager;
    }

    public EditingDomain getEditingDomain() {
        return (EditingDomain)this.editor.getAdapter(EditingDomain.class);
    }

    public AdapterFactory getAdapterFactory() {
        return (AdapterFactory)this.editor.getAdapter(AdapterFactory.class);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.editor.getSelectionSynchronizer().addSelectionProvider((ISelectionProvider)this);
        this.getContextMenuManager().addMenuListener(this.editor.getContextMenuProvider());
        ActionRegistry ar = (ActionRegistry)this.editor.getAdapter(ActionRegistry.class);
        IActionBars actionBars = pageSite.getActionBars();
        ArrayList globalActionIDs = this.editor.getGlobalActionKeys();
        int i = 0;
        while (i < globalActionIDs.size()) {
            String id = (String)globalActionIDs.get(i);
            actionBars.setGlobalActionHandler(id, ar.getAction((Object)id));
            ++i;
        }
        actionBars.updateActionBars();
    }

    public void createControl(Composite parent) {
        this.mainArea = new SashForm(parent, 512);
        this.mainArea.setSashWidth(3);
        this.overviewOutlineArea = new ModelOutlineAreaOverview(this);
        super.createControl((Composite)this.mainArea);
        this.treeviewerOutlineArea = new ModelOutlineAreaTreeviewer(this, this.editor, this.getTreeViewer());
        this.refresh();
    }

    public Control getControl() {
        return this.mainArea;
    }

    public String getCurrentDisplayMode() {
        return this.current_display_mode;
    }

    public void refresh() {
        if (this.mainArea == null || this.mainArea.isDisposed()) {
            return;
        }
        if (PreferenceReader.outlineShowArea.get().equals(OUTLINE_AREA_BOTH) && !this.current_display_mode.equals(OUTLINE_AREA_BOTH)) {
            this.mainArea.setSashWidth(3);
            int[] weights = new int[]{Math.max(PreferenceReader.outlineOverviewSize.get(), 50), Math.max(PreferenceReader.outlineTreeviewSize.get(), 50)};
            this.mainArea.setWeights(weights);
            this.current_display_mode = OUTLINE_AREA_BOTH;
        } else if (PreferenceReader.outlineShowArea.get().equals(OUTLINE_AREA_OVERVIEW) && !this.current_display_mode.equals(OUTLINE_AREA_OVERVIEW)) {
            this.mainArea.setSashWidth(0);
            int[] nArray = new int[2];
            nArray[0] = 100;
            int[] weights = nArray;
            this.mainArea.setWeights(weights);
            this.current_display_mode = OUTLINE_AREA_OVERVIEW;
        } else if (PreferenceReader.outlineShowArea.get().equals(OUTLINE_AREA_TREEVIEW) && !this.current_display_mode.equals(OUTLINE_AREA_TREEVIEW)) {
            this.mainArea.setSashWidth(0);
            int[] nArray = new int[2];
            nArray[1] = 100;
            int[] weights = nArray;
            this.mainArea.setWeights(weights);
            this.current_display_mode = OUTLINE_AREA_TREEVIEW;
        }
        if (this.overviewOutlineArea != null) {
            this.overviewOutlineArea.refresh(this.editor);
        }
        if (this.treeviewerOutlineArea != null) {
            this.treeviewerOutlineArea.refresh(this.getTreeViewer());
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        if (!(event.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof Activity) {
            this.editor.openActivityInNewPage((Activity)selection.getFirstElement());
        }
    }

    public void dispose() {
        this.editor.getSelectionSynchronizer().removeSelectionProvider((ISelectionProvider)this);
        if (this.overviewOutlineArea != null) {
            this.overviewOutlineArea.dispose();
        }
        if (this.treeviewerOutlineArea != null) {
            this.treeviewerOutlineArea.dispose();
        }
        super.dispose();
    }
}

