/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.ldt.core.internal.ast.models.api.Item;
import org.eclipse.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.ldt.core.internal.ast.models.file.LuaExpression;
import org.eclipse.ldt.ui.internal.Activator;
import org.eclipse.ldt.ui.internal.editor.LuaEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (!(selection instanceof TextSelection)) {
            return null;
        }
        int selectionOffset = ((TextSelection)selection).getOffset();
        int selectionLength = ((TextSelection)selection).getLength();
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(editor instanceof LuaEditor)) {
            return null;
        }
        LuaEditor luaEditor = (LuaEditor)editor;
        IModelElement editorInput = luaEditor.getInputModelElement();
        if (!(editorInput instanceof SourceModule)) {
            return null;
        }
        SourceModule sourceModule = (SourceModule)editorInput;
        IDocument document = luaEditor.getDocumentProvider().getDocument((Object)luaEditor.getEditorInput());
        if (document == null) {
            return null;
        }
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)sourceModule);
        LuaExpression luaExpression = LuaASTUtils.getLuaExpressionAt((LuaSourceRoot)luaSourceRoot, (int)selectionOffset, (int)(selectionOffset + selectionLength));
        if (luaExpression == null || !(luaExpression instanceof Identifier)) {
            return null;
        }
        Identifier luaIdentifier = (Identifier)luaExpression;
        Item definition = luaIdentifier.getDefinition();
        if (definition == null) {
            return null;
        }
        List occurrences = definition.getOccurrences();
        if (occurrences.isEmpty()) {
            return null;
        }
        try {
            LinkedModeModel model = new LinkedModeModel();
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, luaIdentifier.sourceStart(), luaIdentifier.matchLength()));
            for (Identifier occurrence : occurrences) {
                if (occurrence == luaIdentifier) continue;
                group.addPosition(new LinkedPosition(document, occurrence.sourceStart(), occurrence.matchLength()));
            }
            model.addGroup(group);
            model.forceInstall();
            LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)luaEditor.getScriptSourceViewer());
            ui.enter();
        }
        catch (BadLocationException e) {
            Activator.logError("Unable to create the UI to rename a variable", e);
        }
        return null;
    }
}

