/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.views;

import java.io.Reader;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.documentation.ScriptDocumentationAccess;
import org.eclipse.dltk.ui.infoviews.AbstractDocumentationView;
import org.eclipse.dltk.ui.text.completion.HTMLPrinter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.ldt.ui.internal.Activator;
import org.eclipse.ldt.ui.internal.LuaDocumentationHelper;
import org.eclipse.ldt.ui.internal.views.Messages;
import org.eclipse.swt.graphics.Color;

public class LuaDocView
extends AbstractDocumentationView {
    protected IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    protected String getNature() {
        return LuaLanguageToolkit.getDefault().getNatureId();
    }

    protected void setBackground(Color color) {
        super.setBackground(LuaDocumentationHelper.getBackgroundColor());
    }

    protected void setForeground(Color color) {
        super.setForeground(LuaDocumentationHelper.getForegroundColor());
    }

    protected Object computeInput(Object input) {
        if (this.getControl() != null) {
            if (input instanceof IModelElement) {
                IModelElement model = (IModelElement)input;
                String scriptdocHtml = this.getScriptdocHtml(model);
                if (scriptdocHtml == null) {
                    scriptdocHtml = this.getDefaultDocumentation(model);
                }
                return scriptdocHtml;
            }
            return null;
        }
        return null;
    }

    private String getScriptdocHtml(IModelElement modelelement) {
        Reader reader = ScriptDocumentationAccess.getHTMLContentReader((String)this.getNature(), (Object)modelelement, (boolean)true, (boolean)true);
        if (reader != null) {
            return LuaDocumentationHelper.generatePage(HTMLPrinter.read((Reader)reader));
        }
        return null;
    }

    private String getDefaultDocumentation(IModelElement modelElement) {
        if (modelElement instanceof ISourceModule || modelElement instanceof IMember) {
            return LuaDocumentationHelper.generatePage(Messages.LuaDocView_NoDocumentationFound);
        }
        return null;
    }
}

