/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.tools.launch.core.factory.CdtSpawnerProcessFactory;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;

public class ValgrindCommand {
    protected static final String WHICH_CMD = "which";
    protected static final String VALGRIND_CMD = "valgrind";
    protected Process process;
    protected String[] args;

    public String getValgrindCommand() {
        return VALGRIND_CMD;
    }

    public String whichVersion(IProject project) throws IOException {
        Process p = RuntimeProcessFactory.getFactory().exec(new String[]{this.getValgrindCommand(), "--version"}, project);
        try {
            StringBuffer out = new StringBuffer();
            this.readIntoBuffer(out, p);
            return out.toString().trim();
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void execute(String[] commandArray, String[] env, File wd, boolean usePty, IProject project) throws IOException {
        this.args = commandArray;
        try {
            this.process = this.startProcess(commandArray, env, wd, usePty, project);
        }
        catch (IOException e) {
            if (this.process != null) {
                this.process.destroy();
            }
            throw e;
        }
    }

    public Process getProcess() {
        return this.process;
    }

    public String getCommandLine() {
        StringBuffer ret = new StringBuffer();
        String[] stringArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            ret.append(arg).append(" ");
            ++n2;
        }
        return ret.toString().trim();
    }

    private Process startProcess(String[] commandArray, String[] env, File workDir, boolean usePty, IProject project) throws IOException {
        if (workDir == null) {
            return CdtSpawnerProcessFactory.getFactory().exec(commandArray, env, project);
        }
        if (PTY.isSupported() && usePty) {
            return CdtSpawnerProcessFactory.getFactory().exec(commandArray, env, workDir, new PTY(), project);
        }
        return CdtSpawnerProcessFactory.getFactory().exec(commandArray, env, workDir, project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readIntoBuffer(StringBuffer out, Process p) throws IOException {
        if (p == null) {
            throw new IOException("Null Process object: unabled to read input into buffer");
        }
        try {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    InputStream err = p.getErrorStream();
                    try {
                        try (InputStream input = p.getInputStream();){
                            int ch;
                            boolean success;
                            boolean bl = success = p.waitFor() == 0;
                            InputStream in = success ? input : err;
                            while ((ch = in.read()) != -1) {
                                out.append((char)ch);
                            }
                            if (!success) {
                                throw new IOException(out.toString());
                            }
                        }
                        if (err == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (err == null) throw throwable;
                        err.close();
                        throw throwable;
                    }
                    err.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                p.getOutputStream().close();
            }
            return;
        }
        finally {
            p.getOutputStream().close();
        }
    }
}

