/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.lifecycle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.ui.internal.editing.LifecycleMappingOperation;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.lifecycle.AbstractLifecycleMappingResolution;
import org.eclipse.m2e.editor.xml.internal.lifecycle.LifecycleMappingDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class LifecycleMappingResolution
extends AbstractLifecycleMappingResolution {
    public LifecycleMappingResolution(IMarker marker, PluginExecutionAction action) {
        super(marker, action);
    }

    public int getOrder() {
        return 50;
    }

    protected void fix(IDocument document, List<IMarker> markers, IProgressMonitor monitor) {
        try {
            if (PluginExecutionAction.ignore.equals((Object)this.action)) {
                this.performIgnore(markers);
            } else {
                PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(document, this.createOperation(markers))});
            }
        }
        catch (IOException e) {
            this.LOG.error("Error generating code in pom.xml", (Throwable)e);
        }
        catch (CoreException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void fix(IResource resource, List<IMarker> markers, IProgressMonitor monitor) {
        try {
            if (PluginExecutionAction.ignore.equals((Object)this.action)) {
                this.performIgnore(markers);
            } else {
                PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple((IFile)resource, this.createOperation(markers))});
            }
        }
        catch (IOException e) {
            this.LOG.error("Error generating code in pom.xml", (Throwable)e);
        }
        catch (CoreException e) {
            this.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void performIgnore(List<IMarker> markers) throws IOException, CoreException {
        final IFile[] pomFile = new IFile[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                LifecycleMappingDialog dialog = new LifecycleMappingDialog(Display.getCurrent().getActiveShell(), (IFile)LifecycleMappingResolution.this.getMarker().getResource(), LifecycleMappingResolution.this.getMarker().getAttribute("groupId", ""), LifecycleMappingResolution.this.getMarker().getAttribute("artifactId", ""), LifecycleMappingResolution.this.getMarker().getAttribute("version", ""), LifecycleMappingResolution.this.getMarker().getAttribute("goal", ""));
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    pomFile[0] = dialog.getPomFile();
                }
            }
        });
        if (pomFile[0] != null) {
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(pomFile[0], this.createOperation(markers))});
        }
    }

    private PomEdits.Operation createOperation(List<IMarker> markers) {
        ArrayList<LifecycleMappingOperation> lst = new ArrayList<LifecycleMappingOperation>();
        for (IMarker m : markers) {
            String pluginGroupId = m.getAttribute("groupId", "");
            String pluginArtifactId = m.getAttribute("artifactId", "");
            String pluginVersion = m.getAttribute("version", "");
            String[] goals = new String[]{m.getAttribute("goal", "")};
            lst.add(new LifecycleMappingOperation(pluginGroupId, pluginArtifactId, pluginVersion, this.action, goals));
        }
        return new PomEdits.CompoundOperation(lst.toArray(new PomEdits.Operation[lst.size()]));
    }

    public String getLabel() {
        String goal = this.getMarker().getAttribute("goal", "");
        return PluginExecutionAction.ignore.equals((Object)this.action) ? NLS.bind((String)Messages.LifecycleMappingProposal_ignore_label, (Object)goal) : NLS.bind((String)Messages.LifecycleMappingProposal_execute_label, (Object)goal);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.getQuickAssistContext() == null) {
            return null;
        }
        String pluginGroupId = this.getMarker().getAttribute("groupId", "");
        String pluginArtifactId = this.getMarker().getAttribute("artifactId", "");
        String pluginVersion = this.getMarker().getAttribute("version", "");
        String goal = this.getMarker().getAttribute("goal", "");
        String execution = this.getMarker().getAttribute("executionId", "-");
        String phase = this.getMarker().getAttribute("lifecyclePhase", "-");
        String info = NLS.bind((String)Messages.LifecycleMappingProposal_all_desc, (Object[])new Object[]{goal, execution, phase, String.valueOf(pluginGroupId) + ":" + pluginArtifactId + ":" + pluginVersion, PluginExecutionAction.ignore.equals((Object)this.action) ? Messages.LifecycleMappingProposal_ignore_desc : Messages.LifecycleMappingProposal_execute_desc});
        return info;
    }
}

