/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.overlay.internal.modulecore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.wtp.overlay.internal.Messages;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.IFilteredVirtualFolder;
import org.eclipse.m2e.wtp.overlay.internal.modulecore.IResourceFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFile;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceListVirtualFolder
extends VirtualFolder
implements IFilteredVirtualFolder {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceListVirtualFolder.class);
    private ArrayList<IResource> children = new ArrayList();
    private ArrayList<IContainer> underlying = new ArrayList();
    private IResourceFilter filter;

    public ResourceListVirtualFolder(IProject aComponentProject, IPath aRuntimePath) {
        super(aComponentProject, aRuntimePath);
    }

    public ResourceListVirtualFolder(IProject aComponentProject, IPath aRuntimePath, IContainer[] underlyingContainers) {
        this(aComponentProject, aRuntimePath);
        this.addUnderlyingResource((IResource[])underlyingContainers);
    }

    public ResourceListVirtualFolder(IProject aComponentProject, IPath aRuntimePath, IContainer[] underlyingContainers, IResource[] looseResources) {
        this(aComponentProject, aRuntimePath, underlyingContainers);
        this.addChildren(looseResources);
    }

    @Override
    public void setFilter(IResourceFilter filter) {
        this.filter = filter;
    }

    protected void addUnderlyingResource(IResource resource) {
        if (resource instanceof IContainer) {
            this.underlying.add((IContainer)resource);
            try {
                IResource[] newChildren = ((IContainer)resource).members();
                int i = 0;
                while (i < newChildren.length) {
                    this.children.add(newChildren[i]);
                    ++i;
                }
            }
            catch (CoreException ce) {
                LOG.error(ce.getLocalizedMessage(), (Throwable)ce);
            }
        }
    }

    protected void addUnderlyingResource(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            this.addUnderlyingResource(resources[i]);
            ++i;
        }
    }

    protected void addChild(IResource resource) {
        this.children.add(resource);
    }

    protected void addChildren(IResource[] resources) {
        this.children.addAll(Arrays.asList(resources));
    }

    public IResource getUnderlyingResource() {
        return this.getUnderlyingFolder();
    }

    public IResource[] getUnderlyingResources() {
        return this.getUnderlyingFolders();
    }

    public IContainer getUnderlyingFolder() {
        return this.underlying.size() > 0 ? this.underlying.get(0) : null;
    }

    public IContainer[] getUnderlyingFolders() {
        return this.underlying.toArray(new IContainer[this.underlying.size()]);
    }

    public IVirtualResource[] members(int memberFlags) throws CoreException {
        HashMap<String, IVirtualResource> virtualResources = new HashMap<String, IVirtualResource>();
        IResource[] resources = this.children.toArray(new IResource[this.children.size()]);
        int i = 0;
        while (i < resources.length) {
            this.handleResource(resources[i], virtualResources, memberFlags);
            ++i;
        }
        Collection c = virtualResources.values();
        return c.toArray(new IVirtualResource[c.size()]);
    }

    protected void handleResource(final IResource resource, HashMap<String, IVirtualResource> map, int memberFlags) throws CoreException {
        if (resource == null) {
            return;
        }
        boolean isFile = resource instanceof IFile;
        String path = resource.getLocation().toPortableString();
        if (this.filter != null && !this.filter.accepts(path, isFile)) {
            return;
        }
        if (isFile) {
            if (!map.containsKey(resource.getName())) {
                VirtualFile virtFile = new VirtualFile(this.getProject(), this.getRuntimePath().append(((IFile)resource).getName()), (IFile)resource){

                    public IPath getWorkspaceRelativePath() {
                        IPath wrp = resource.getFullPath();
                        return wrp;
                    }
                };
                map.put(resource.getName(), (IVirtualResource)virtFile);
                return;
            }
        } else if (resource instanceof IContainer) {
            IContainer realContainer = (IContainer)resource;
            IVirtualResource previousValue = map.get(resource.getName());
            if (previousValue != null && previousValue instanceof ResourceListVirtualFolder) {
                ((ResourceListVirtualFolder)previousValue).addUnderlyingResource((IResource)realContainer);
            } else if (previousValue == null) {
                ResourceListVirtualFolder childFolder = new ResourceListVirtualFolder(this.getProject(), this.getRuntimePath().append(resource.getName()));
                childFolder.addUnderlyingResource((IResource)realContainer);
                if (this.filter != null) {
                    childFolder.setFilter(this.filter);
                }
                map.put(resource.getName(), (IVirtualResource)childFolder);
            }
        }
    }

    @Override
    public IResourceFilter getFilter() {
        return this.filter;
    }

    public IVirtualResource findMember(IPath path, int searchFlags) {
        if (this.underlying == null || path == null) {
            return null;
        }
        if (path.isAbsolute()) {
            path = path.makeRelative();
        }
        for (IResource iResource : this.underlying) {
            IContainer c;
            IResource candidate;
            if (!(iResource instanceof IContainer) || (candidate = (c = (IContainer)iResource).findMember(path, true)) == null || !candidate.exists()) continue;
            HashMap<String, IVirtualResource> map = new HashMap<String, IVirtualResource>(1);
            try {
                this.handleResource(candidate, map, 0);
                if (map.isEmpty()) continue;
                IVirtualResource vr = map.values().iterator().next();
                return vr;
            }
            catch (CoreException e) {
                String message = NLS.bind((String)Messages.ResourceListVirtualFolder_Error_Finding_Member, (Object)path, (Object)candidate);
                LOG.error(message, (Throwable)e);
            }
        }
        return null;
    }
}

