/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.dsls.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EcoreFactoryImpl;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.dsls.tcs.injector.ModelAdapter;
import org.eclipse.m2m.atl.dsls.tcs.injector.ParserLauncher;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.Model;

public class EMFTCSInjector {
    private static Map parameterTypes = new HashMap();
    protected ModelAdapter problemsModelAdapter;
    protected ModelAdapter targetModelAdapter;
    static /* synthetic */ Class class$0;

    static {
        parameterTypes.put("name", "String");
        parameterTypes.put("keepNL", "String");
        parameterTypes.put("keepLocation", "String");
        parameterTypes.put("keepComments", "String");
        parameterTypes.put("tabSize", "String");
        parameterTypes.put("parserGenerator", "String");
        parameterTypes.put("hyperlinks", "Map");
        parameterTypes.put("trace", "Map");
        parameterTypes.put("locationByElement", "Map");
        parameterTypes.put("problems", "Model:Problem");
        parameterTypes.put("lexerClass", "Class");
        parameterTypes.put("parserClass", "Class");
    }

    public Map getParameterTypes() {
        return parameterTypes;
    }

    public String getPrefix() {
        return "ebnf2";
    }

    public Object inject(EMFModel target, InputStream source, Map params) throws IOException {
        return this.inject(target, new InputStreamReader(source), params);
    }

    public Object inject(EMFModel target, Reader source, Map params) throws IOException {
        EMFInjectorAdapter targetModelAdapter = new EMFInjectorAdapter(target);
        EMFModel problems = (EMFModel)params.get("problems");
        if (problems != null) {
            EMFInjectorAdapter problemsModelAdapter = new EMFInjectorAdapter(problems);
            params.put("problems", problemsModelAdapter);
        }
        EObject root = (EObject)new ParserLauncher().parse(targetModelAdapter, source, params);
        target.commitToResource();
        if (problems != null) {
            problems.commitToResource();
        }
        return root;
    }

    public class EMFInjectorAdapter
    implements ModelAdapter {
        private final EMFModel emfModel;
        private final Model model;
        private final Metamodel metamodel;

        public EMFInjectorAdapter(Object model) {
            this.emfModel = (EMFModel)model;
            this.model = EmftvmFactory.eINSTANCE.createModel();
            if (this.emfModel.getResource() == null) {
                Object element = this.emfModel.newElement((Object)EcorePackage.eINSTANCE.getEClass());
                this.emfModel.getResource().getContents().remove(element);
            }
            this.model.setResource(this.emfModel.getResource());
            this.metamodel = EmftvmFactory.eINSTANCE.createMetamodel();
            this.metamodel.setResource(this.emfModel.getReferenceModel().getResource());
        }

        public Object getModel() {
            return this.emfModel;
        }

        public Object get(Object modelElement, String name) {
            if (modelElement == null) {
                return null;
            }
            EObject eo = (EObject)modelElement;
            EStructuralFeature sf = eo.eClass().getEStructuralFeature(name);
            if (sf == null) {
                return null;
            }
            return eo.eGet(sf);
        }

        public Object createElement(String typeName) {
            return this.model.newElement(this.getTypeByName(typeName));
        }

        public Set getElementsByType(String typeName) {
            return this.model.allInstancesOf(this.getTypeByName(typeName)).asSet();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void set(Object modelElement, String name, Object value) {
            String targetType;
            if (value == null) {
                return;
            }
            EObject eo = (EObject)modelElement;
            EStructuralFeature feature = eo.eClass().getEStructuralFeature(name);
            if (feature == null) {
                return;
            }
            if (value instanceof Integer && ("java.lang.Double".equals(targetType = feature.getEType().getInstanceClassName()) || "java.lang.Float".equals(targetType))) {
                value = new Double(((Integer)value).doubleValue());
            }
            EClassifier type = feature.getEType();
            boolean targetIsEnum = type instanceof EEnum;
            Object oldValue = eo.eGet(feature);
            if (oldValue instanceof Collection) {
                Collection oldCol = (Collection)oldValue;
                if (value instanceof Collection) {
                    if (targetIsEnum) {
                        EEnum eenum = (EEnum)type;
                        Iterator i = ((Collection)value).iterator();
                        while (i.hasNext()) {
                            Object v = i.next();
                            oldCol.add(eenum.getEEnumLiteralByLiteral(v.toString()).getInstance());
                        }
                        return;
                    } else {
                        oldCol.addAll((Collection)value);
                    }
                    return;
                } else if (targetIsEnum) {
                    EEnum eenum = (EEnum)type;
                    oldCol.add(eenum.getEEnumLiteralByLiteral(value.toString()).getInstance());
                    return;
                } else {
                    oldCol.add(value);
                }
                return;
            } else {
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    value = !c.isEmpty() ? c.iterator().next() : null;
                }
                if (targetIsEnum) {
                    EEnum eenum = (EEnum)type;
                    if (value == null) return;
                    EEnumLiteral literal = eenum.getEEnumLiteral(value.toString());
                    if (literal == null) return;
                    eo.eSet(feature, (Object)literal.getInstance());
                    return;
                } else {
                    eo.eSet(feature, value);
                }
            }
        }

        public boolean isCandidate(Object ame, String typeName) {
            boolean ret = false;
            EClass valueType = this.getTypeByName(typeName);
            Object type = this.getType(ame);
            if (valueType instanceof EObject) {
                EObject o = (EObject)valueType;
                EObject t = (EObject)type;
                if (o instanceof EClass && t instanceof EClass) {
                    try {
                        ret = o.equals(t) || ((EClass)o).isSuperTypeOf((EClass)t);
                    }
                    catch (Exception e) {
                        ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            return ret;
        }

        public Object getType(Object value) {
            if (value instanceof EObject) {
                return ((EObject)value).eClass();
            }
            if (value instanceof EList) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.util.ArrayList");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            return value.getClass();
        }

        public boolean isAModelElement(Object me) {
            return me instanceof EObject;
        }

        public String getString(Object ame, String propName) {
            return this.get(ame, propName).toString();
        }

        public Object createEnumLiteral(String name) {
            EEnumLiteral ret = EcoreFactoryImpl.eINSTANCE.createEEnumLiteral();
            ret.setName(name);
            return ret;
        }

        private EClass getTypeByName(String typeName) {
            EClassifier type = this.metamodel.findType(typeName);
            return type instanceof EClass ? (EClass)type : null;
        }
    }
}

