/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.DetailResultProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultMetaData {
    private List<ContextProvider> contextProviders = new ArrayList<ContextProvider>();
    private List<DetailResultProvider> resultProviders = new ArrayList<DetailResultProvider>();
    private int preSortedColumnIndex;
    private Column.SortDirection preSortedSortDirection;
    private Set<ContextDerivedData.DerivedOperation> operations;

    private ResultMetaData() {
    }

    public List<ContextProvider> getContextProviders() {
        return this.contextProviders;
    }

    public List<DetailResultProvider> getDetailResultProviders() {
        return this.resultProviders;
    }

    public boolean isPreSorted() {
        return this.preSortedSortDirection != null;
    }

    public int getPreSortedColumnIndex() {
        return this.preSortedColumnIndex;
    }

    public Column.SortDirection getPreSortedDirection() {
        return this.preSortedSortDirection;
    }

    public Collection<ContextDerivedData.DerivedOperation> getDerivedOperations() {
        return this.operations;
    }

    /* synthetic */ ResultMetaData(ResultMetaData resultMetaData) {
        this();
    }

    public static final class Builder {
        ResultMetaData data = new ResultMetaData(null);

        public Builder addContext(ContextProvider provider) {
            this.data.contextProviders.add(provider);
            return this;
        }

        public Builder addDetailResult(DetailResultProvider provider) {
            this.data.resultProviders.add(provider);
            return this;
        }

        public Builder setIsPreSortedBy(int columnIndex, Column.SortDirection direction) {
            this.data.preSortedColumnIndex = columnIndex;
            this.data.preSortedSortDirection = direction;
            return this;
        }

        public Builder addDerivedData(ContextDerivedData.DerivedOperation action) {
            if (this.data.operations == null) {
                this.data.operations = new HashSet();
            }
            this.data.operations.add(action);
            return this;
        }

        public ResultMetaData build() {
            ResultMetaData answer = this.data;
            this.data = null;
            answer.contextProviders = Collections.unmodifiableList(answer.contextProviders);
            return answer;
        }
    }
}

