/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converters {
    private static final Map<Class<?>, IConverter<?>> converters = new HashMap();

    static {
        Converters.register(String.class, new StringFormat());
        Converters.register(Boolean.class, new BooleanFormat());
        Converters.register(Boolean.TYPE, new BooleanFormat());
        Converters.register(Integer.class, new IntegerFormat());
        Converters.register(Integer.TYPE, new IntegerFormat());
        Converters.register(Long.class, new LongFormat());
        Converters.register(Long.TYPE, new LongFormat());
        Converters.register(Double.class, new DoubleFormat());
        Converters.register(Double.TYPE, new DoubleFormat());
        Converters.register(Float.class, new FloatFormat());
        Converters.register(Float.TYPE, new FloatFormat());
        Converters.register(Short.class, new ShortFormat());
        Converters.register(Short.TYPE, new ShortFormat());
        Converters.register(Pattern.class, new PatternFormat());
        Converters.register(File.class, new FileConverter());
    }

    private static void register(Class<?> clazz, IConverter<?> converter) {
        converters.put(clazz, converter);
    }

    static IConverter<Object> getConverter(Class<?> clazz) {
        EnumConverter converter = converters.get(clazz);
        if (converter == null && clazz.isEnum()) {
            converter = new EnumConverter(clazz);
            converters.put(clazz, converter);
        }
        return converter;
    }

    public static String convertAndEscape(Class<?> type, Object value) {
        boolean hasBackslash;
        IConverter<Object> converter = Converters.getConverter(type);
        String result = converter != null ? converter.toString(value) : String.valueOf(value);
        boolean hasQuote = result.indexOf(34) >= 0;
        boolean hasSpace = result.indexOf(32) >= 0;
        int ii = 0;
        while (!hasSpace && ii < result.length()) {
            if (Character.isWhitespace(result.charAt(ii))) {
                hasSpace = true;
            }
            ++ii;
        }
        boolean bl = hasBackslash = result.indexOf("\\\\") >= 0 || result.indexOf("\\\"") >= 0;
        if (!(hasQuote || hasSpace || hasBackslash)) {
            return result;
        }
        StringBuilder buf = new StringBuilder(result.length() * 110 / 100);
        if (hasSpace) {
            buf.append("\"");
        }
        int ii2 = 0;
        while (ii2 < result.length()) {
            if (hasQuote && result.charAt(ii2) == '\"') {
                buf.append("\\");
            }
            if (hasBackslash && ii2 + 1 < result.length() && result.charAt(ii2) == '\\' && (result.charAt(ii2 + 1) == '\\' || result.charAt(ii2 + 1) == '\"')) {
                buf.append("\\");
            }
            buf.append(result.charAt(ii2));
            ++ii2;
        }
        if (hasSpace) {
            buf.append("\"");
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BooleanFormat
    implements IConverter<Boolean> {
        private BooleanFormat() {
        }

        @Override
        public Boolean toObject(String string, Argument.Advice advice) {
            return Boolean.parseBoolean(string);
        }

        @Override
        public String toString(Boolean object) {
            return object.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DoubleFormat
    implements IConverter<Double> {
        private DoubleFormat() {
        }

        @Override
        public Double toObject(String string, Argument.Advice advice) {
            return Double.parseDouble(string);
        }

        @Override
        public String toString(Double object) {
            return String.valueOf(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EnumConverter
    implements IConverter<Object> {
        Object[] values;
        String[] names;

        public EnumConverter(Class<?> enumClass) {
            this.values = enumClass.getEnumConstants();
            try {
                Method nameMethod = enumClass.getMethod("name", new Class[0]);
                this.names = new String[this.values.length];
                int ii = 0;
                while (ii < this.values.length) {
                    this.names[ii] = (String)nameMethod.invoke(this.values[ii], new Object[0]);
                    ++ii;
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object toObject(String string, Argument.Advice advice) {
            int ii = 0;
            while (ii < this.names.length) {
                if (this.names[ii].equals(string)) {
                    return this.values[ii];
                }
                ++ii;
            }
            throw new IllegalArgumentException(MessageUtil.format(Messages.Converters_Error_InvalidEnumValue, Arrays.toString(this.names)));
        }

        @Override
        public String toString(Object object) {
            int ii = 0;
            while (ii < this.values.length) {
                if (this.values[ii] == object) {
                    return this.names[ii];
                }
                ++ii;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileConverter
    implements IConverter<File> {
        private FileConverter() {
        }

        @Override
        public File toObject(String path, Argument.Advice advice) {
            return new File(path);
        }

        @Override
        public String toString(File file) {
            return file.getAbsolutePath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FloatFormat
    implements IConverter<Float> {
        private FloatFormat() {
        }

        @Override
        public Float toObject(String string, Argument.Advice advice) {
            return Float.valueOf(Float.parseFloat(string));
        }

        @Override
        public String toString(Float object) {
            return String.valueOf(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface IConverter<O> {
        public String toString(O var1);

        public O toObject(String var1, Argument.Advice var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntegerFormat
    implements IConverter<Integer> {
        private IntegerFormat() {
        }

        @Override
        public Integer toObject(String string, Argument.Advice advice) {
            return Integer.parseInt(string);
        }

        @Override
        public String toString(Integer object) {
            return String.valueOf(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LongFormat
    implements IConverter<Long> {
        private LongFormat() {
        }

        @Override
        public Long toObject(String string, Argument.Advice advice) {
            return Long.parseLong(string);
        }

        @Override
        public String toString(Long object) {
            return String.valueOf(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PatternFormat
    implements IConverter<Pattern> {
        private PatternFormat() {
        }

        @Override
        public Pattern toObject(String pattern, Argument.Advice advice) {
            if (advice == Argument.Advice.CLASS_NAME_PATTERN) {
                pattern = PatternUtil.smartFix(pattern, false);
            }
            return Pattern.compile(pattern);
        }

        @Override
        public String toString(Pattern object) {
            return object.pattern();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ShortFormat
    implements IConverter<Short> {
        private ShortFormat() {
        }

        @Override
        public Short toObject(String string, Argument.Advice advice) {
            return Short.parseShort(string);
        }

        @Override
        public String toString(Short object) {
            return String.valueOf(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringFormat
    implements IConverter<String> {
        private StringFormat() {
        }

        @Override
        public String toObject(String string, Argument.Advice advice) {
            return string;
        }

        @Override
        public String toString(String object) {
            return object;
        }
    }
}

