/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.viewer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.refined.RefinedStructuredResult;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.RendererRegistry;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.TestSuite;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

final class ExportActions {
    private ExportActions() {
    }

    private static class ContextImpl
    implements IOutputter.Context {
        private File outputDir;
        private IQueryContext context;

        public ContextImpl(IQueryContext context, File outputDir) {
            this.context = context;
            this.outputDir = outputDir;
        }

        public String getId() {
            return "X";
        }

        public int getLimit() {
            return 0;
        }

        public File getOutputDirectory() {
            return this.outputDir;
        }

        public String getPathToRoot() {
            return "";
        }

        public IQueryContext getQueryContext() {
            return this.context;
        }

        public String addIcon(URL icon) {
            return null;
        }

        public String addContextResult(String name, IResult result) {
            return null;
        }

        public boolean hasLimit() {
            return false;
        }

        public boolean isColumnVisible(int columnIndex) {
            return true;
        }

        public String param(String key, String defaultValue) {
            return defaultValue;
        }

        public String param(String key) {
            return null;
        }

        public boolean isTotalsRowVisible() {
            return true;
        }
    }

    static class CsvExport
    extends Action {
        private Control control;
        private IResult result;
        private IQueryContext queryContext;

        public CsvExport(Control control, IResult result, IQueryContext queryContext) {
            super(Messages.ExportActions_ExportToCSV, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/export_csv.gif"));
            this.control = control;
            this.result = result;
            this.queryContext = queryContext;
        }

        public void run() {
            ExportDialog dialog = new ExportDialog(this.control.getShell(), new String[]{Messages.ExportActions_CsvFiles}, new String[]{"*.csv"});
            final String fileName = dialog.open();
            if (fileName == null) {
                return;
            }
            new Job(Messages.ExportActions_ExportCSV){

                protected IStatus run(IProgressMonitor monitor) {
                    PrintWriter writer = null;
                    try {
                        try {
                            IOutputter outputter = RendererRegistry.instance().match("csv", CsvExport.this.result.getClass());
                            writer = new PrintWriter(new FileWriter(fileName));
                            outputter.process((IOutputter.Context)new ContextImpl(CsvExport.this.queryContext, new File(fileName).getParentFile()), CsvExport.this.result, (Writer)writer);
                            writer.flush();
                            writer.close();
                        }
                        catch (IOException e) {
                            IStatus iStatus = ErrorHelper.createErrorStatus(e);
                            if (writer != null) {
                                writer.close();
                            }
                            return iStatus;
                        }
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    private static class ExportDialog {
        private FileDialog dlg;

        public ExportDialog(Shell shell, String[] names, String[] extentions) {
            this.dlg = new FileDialog(shell, 8192);
            this.dlg.setFilterNames(names);
            this.dlg.setFilterExtensions(extentions);
        }

        public String open() {
            String fileName = null;
            boolean done = false;
            while (!done) {
                fileName = this.dlg.open();
                if (fileName == null) {
                    done = true;
                    continue;
                }
                File file = new File(fileName);
                if (file.exists()) {
                    MessageBox mb = new MessageBox(this.dlg.getParent(), 200);
                    mb.setMessage(MessageUtil.format((String)Messages.ExportActions_AlreadyExists, (Object[])new Object[]{fileName}));
                    done = mb.open() == 64;
                    continue;
                }
                done = true;
            }
            return fileName;
        }
    }

    static class HtmlExport
    extends Action {
        private Control control;
        private RefinedStructuredResult result;
        private IQueryContext queryContext;

        public HtmlExport(Control control, RefinedStructuredResult result, IQueryContext queryContext) {
            super(Messages.ExportActions_ExportToHTML, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/export_html.gif"));
            this.control = control;
            this.result = result;
            this.queryContext = queryContext;
        }

        public void run() {
            int limit;
            ExportDialog dialog = new ExportDialog(this.control.getShell(), new String[]{Messages.ExportActions_ZippedWebPage}, new String[]{"*.zip"});
            final String fileName = dialog.open();
            if (fileName == null) {
                return;
            }
            RefinedResultViewer.ControlItem controlItem = (RefinedResultViewer.ControlItem)this.control.getData("$control");
            int n = limit = controlItem != null && controlItem.getTotals() != null ? controlItem.getTotals().getVisibleItems() : 25;
            if (this.control instanceof Tree) {
                TreeItem[] items;
                Tree tree = (Tree)this.control;
                LinkedList<TreeItem> stack = new LinkedList<TreeItem>();
                TreeItem[] treeItemArray = items = tree.getItems();
                int n2 = items.length;
                int n3 = 0;
                while (n3 < n2) {
                    TreeItem treeItem = treeItemArray[n3];
                    stack.add(treeItem);
                    ++n3;
                }
                final HashSet<Object> expanded = new HashSet<Object>();
                while (!stack.isEmpty()) {
                    TreeItem item = (TreeItem)stack.removeFirst();
                    if (!item.getExpanded()) continue;
                    Object data = item.getData();
                    if (data != null) {
                        expanded.add(data);
                    }
                    TreeItem[] treeItemArray2 = items = item.getItems();
                    int n4 = items.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        TreeItem treeItem = treeItemArray2[n5];
                        stack.add(treeItem);
                        ++n5;
                    }
                }
                this.result.setSelectionProvider(new ISelectionProvider(){

                    public boolean isExpanded(Object row) {
                        return expanded.contains(row);
                    }

                    public boolean isSelected(Object row) {
                        return false;
                    }
                });
            }
            new Job(Messages.ExportActions_ExportHTML){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        QuerySpec spec = new QuerySpec(Messages.ExportActions_Export, (IResult)HtmlExport.this.result);
                        spec.set("limit", String.valueOf(limit));
                        TestSuite suite = new TestSuite.Builder((Spec)spec).output(new File(fileName)).build(HtmlExport.this.queryContext);
                        suite.execute((IProgressListener)new ProgressMonitorWrapper(monitor));
                        return Status.OK_STATUS;
                    }
                    catch (IOException e) {
                        return ErrorHelper.createErrorStatus(e);
                    }
                    catch (SnapshotException e) {
                        return ErrorHelper.createErrorStatus(e);
                    }
                }
            }.schedule();
        }
    }

    static class TxtExport
    extends Action {
        private Control control;

        public TxtExport(Control control) {
            super(Messages.ExportActions_ExportToTxt, MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/export_txt.gif"));
            this.control = control;
        }

        public void run() {
            ExportDialog dialog = new ExportDialog(this.control.getShell(), new String[]{Messages.ExportActions_PlainText}, new String[]{"*.txt"});
            String fileName = dialog.open();
            if (fileName == null) {
                return;
            }
            Copy.exportToTxtFile(this.control, fileName);
        }
    }
}

