/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.celleditors.composite;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.facet.widgets.celleditors.AbstractCellEditorComposite;
import org.eclipse.emf.facet.widgets.celleditors.ICompositeEditorFactory;
import org.eclipse.emf.facet.widgets.celleditors.IListener;
import org.eclipse.emf.facet.widgets.celleditors.IWidget2;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.modisco.infra.discovery.ui.internal.celleditors.composite.IComposedCellEditorListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComposedCellEditor
extends CellEditor {
    private final ICompositeEditorFactory<Object> cellCompositeFactory;
    private final List<IComposedCellEditorListener> listeners = new ArrayList<IComposedCellEditorListener>();

    public ComposedCellEditor(Composite parent, ICompositeEditorFactory<?> cellCompositeFactory) {
        this.cellCompositeFactory = cellCompositeFactory;
        this.setStyle(0);
        this.create(parent);
    }

    protected void doSetValue(Object value) {
        ((IWidget2)this.getControl()).setValue(value);
    }

    protected void doSetFocus() {
        this.getControl().setFocus();
    }

    protected Object doGetValue() {
        return ((IWidget2)this.getControl()).getValue();
    }

    protected Control createControl(Composite parent) {
        AbstractCellEditorComposite compositeEditor = this.cellCompositeFactory.createCompositeEditor(parent, 0);
        compositeEditor.addCommitListener(new IListener(){

            public void handleEvent() {
                ComposedCellEditor.this.fireApplyEditorValue();
                ComposedCellEditor.this.deactivate();
            }
        });
        return compositeEditor;
    }

    public void addListener(IComposedCellEditorListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IComposedCellEditorListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireCellEditorDeactivated() {
        for (IComposedCellEditorListener listener : new ArrayList<IComposedCellEditorListener>(this.listeners)) {
            listener.deactivated();
        }
    }

    public void deactivate() {
        if (this.isActivated()) {
            this.fireCellEditorDeactivated();
        }
        super.deactivate();
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }
}

