/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.modisco.infra.discovery.catalog.DirectionKind;
import org.eclipse.modisco.infra.discovery.ui.internal.wizards.DiscoveryParameterLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractModelDiscovererParameters {
    private static AbstractModelDiscovererParameters instance;
    private final List<DiscoveryParameterLine> parameters = new ArrayList<DiscoveryParameterLine>();

    public AbstractModelDiscovererParameters() {
        DiscoveryParameterLine targetModel = new DiscoveryParameterLine();
        targetModel.setName("targetModel");
        targetModel.setType("org.eclipse.emf.ecore.resource.Resource");
        targetModel.setDescription("A model container, usually an output of the discovery but which might be provided also as input.");
        targetModel.setDirection(DirectionKind.INOUT);
        targetModel.setRequired(false);
        this.parameters.add(targetModel);
        DiscoveryParameterLine serializeTarget = new DiscoveryParameterLine();
        serializeTarget.setName("serializeTarget");
        serializeTarget.setType("boolean");
        serializeTarget.setDescription("A boolean indicating if some target model serialization is wished. Save behavior depends on Discoverer implementation. The standard behavior is to use XMI serialization.");
        serializeTarget.setDirection(DirectionKind.IN);
        serializeTarget.setRequired(false);
        this.parameters.add(serializeTarget);
        DiscoveryParameterLine targetURI = new DiscoveryParameterLine();
        targetURI.setName("targetURI");
        targetURI.setType("org.eclipse.emf.common.util.URI");
        targetURI.setDescription("A location for optional model serialization. Save behavior depends on Discoverer implementation.");
        targetURI.setDirection(DirectionKind.IN);
        targetURI.setRequired(false);
        this.parameters.add(targetURI);
    }

    public static AbstractModelDiscovererParameters getInstance() {
        if (instance == null) {
            instance = new AbstractModelDiscovererParameters();
        }
        return instance;
    }

    public List<DiscoveryParameterLine> getParameters() {
        return this.parameters;
    }

    public static boolean isInheritedParameter(Object param) {
        return AbstractModelDiscovererParameters.getInstance().getParameters().contains(param);
    }
}

