/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildModel;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.core.spi.BuildConnector;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.ui.spi.BuildConnectorUi;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.internal.builds.ui.BuildConnectorDescriptor;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.commands.OpenHandler;
import org.eclipse.mylyn.internal.builds.ui.notifications.BuildsServiceNotification;
import org.eclipse.mylyn.internal.builds.ui.view.BuildsView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class BuildsUi {
    private static HashMap<String, BuildConnectorDescriptor> descriptorByKind;

    public static synchronized BuildConnector getConnector(String connectorKind) {
        BuildConnectorDescriptor descriptor = BuildsUi.getConnectorDescriptorByKind().get(connectorKind);
        return descriptor != null ? descriptor.getCoreDelegate() : null;
    }

    public static synchronized BuildConnectorUi getConnectorUi(String connectorKind) {
        BuildConnectorDescriptor descriptor = BuildsUi.getConnectorDescriptorByKind().get(connectorKind);
        return descriptor != null ? descriptor.getUiDelegate() : null;
    }

    public static synchronized IBuildModel getModel() {
        return BuildsUiInternal.getModel();
    }

    private static synchronized HashMap<String, BuildConnectorDescriptor> getConnectorDescriptorByKind() {
        IExtension[] extensions;
        if (descriptorByKind != null) {
            return descriptorByKind;
        }
        descriptorByKind = new HashMap();
        MultiStatus result = new MultiStatus("org.eclipse.mylyn.builds.ui", 0, "Build connectors failed to load.", null);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint connectorsExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.builds.ui.connectors");
        IExtension[] iExtensionArray = extensions = connectorsExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                BuildConnectorDescriptor descriptor = new BuildConnectorDescriptor(element);
                IStatus status = descriptor.validate();
                if (status.isOK()) {
                    descriptorByKind.put(descriptor.getConnectorKind(), descriptor);
                } else {
                    result.add(status);
                }
                ++n4;
            }
            ++n2;
        }
        if (!result.isOK()) {
            StatusManager.getManager().handle((IStatus)result);
        }
        return descriptorByKind;
    }

    public static IBuildServer createServer(String connectorKind) {
        return BuildsUiInternal.createServer(connectorKind, new RepositoryLocation());
    }

    public static BuildConnector getConnector(IBuildServer server) {
        return BuildsUi.getConnector(((BuildServer)server).getConnectorKind());
    }

    public static BuildConnectorUi getConnectorUi(IBuildServer server) {
        return BuildsUi.getConnectorUi(((BuildServer)server).getConnectorKind());
    }

    public static void serverDiscovered(String title, String description) {
        BuildsServiceNotification notification = new BuildsServiceNotification(title, description);
        NotificationsUi.getService().notify(Collections.singletonList(notification));
    }

    public static void open(IBuildElement element) {
        List<EditorHandle> handle;
        IWorkbenchPage page;
        Assert.isNotNull((Object)element);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (handle = OpenHandler.open(page, Collections.singletonList(element))).get(0).getStatus() != null && handle.get(0).getStatus().isOK()) {
            return;
        }
        BuildsView.openInActivePerspective();
    }

    public static List<RepositoryLocation> getServerLocations() {
        final ArrayList<RepositoryLocation> locations = new ArrayList<RepositoryLocation>();
        final IBuildModel model = BuildsUi.getModel();
        BuildsUiInternal.getOperationService().getRealm().syncExec(new Runnable(){

            @Override
            public void run() {
                List servers = model.getServers();
                for (IBuildServer server : servers) {
                    locations.add(server.getLocation());
                }
            }
        });
        return locations;
    }
}

