/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.factories;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.mylyn.internal.gerrit.core.egit.GerritToGitMapping;
import org.eclipse.mylyn.internal.gerrit.ui.factories.Messages;
import org.eclipse.mylyn.internal.gerrit.ui.factories.OpenCommitUiFactory;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;
import org.eclipse.swt.widgets.Display;

public class OpenParentCommitUiFactory
extends OpenCommitUiFactory {
    private final String commitId;

    public OpenParentCommitUiFactory(IUiContext context, IReviewItemSet set, String commitId) {
        super(context, set);
        this.commitId = commitId;
    }

    @Override
    public void execute() {
        GerritToGitMapping mapping = this.getGitRepository(true);
        if (mapping != null) {
            final ParentCommitJob job = new ParentCommitJob(Messages.OpenCommitUiFactory_Opening_Commit_Viewer, mapping.getRepository(), this.commitId);
            job.schedule();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CommitEditor.openQuiet((RepositoryCommit)job.getCommit());
                        }
                    });
                }
            });
        }
    }

    public static class ParentCommitJob
    extends Job {
        private final Repository repository;
        private RepositoryCommit commit;
        private final String commitId;

        public ParentCommitJob(String name, Repository repository, String commitId) {
            super(name);
            this.repository = repository;
            this.commitId = commitId;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                RevCommit revCommit = this.getRevCommit();
                this.commit = new RepositoryCommit(this.repository, revCommit);
            }
            catch (Exception e) {
                return new Status(4, "org.eclipse.mylyn.gerrit.ui", "Patch set retrieval failed", (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        public RepositoryCommit getCommit() {
            return this.commit;
        }

        private RevCommit getRevCommit() throws AmbiguousObjectException, IOException {
            ObjectId ref = this.repository.resolve(this.commitId);
            Throwable throwable = null;
            Object var3_4 = null;
            try (RevWalk walker = new RevWalk(this.repository);){
                return walker.parseCommit((AnyObjectId)ref);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

