/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.model;

public class TracRepositoryInfo {
    private final int apiEpoch;
    private final int apiMajor;
    private final int apiMinor;
    private String version;

    public TracRepositoryInfo() {
        this(null);
    }

    public TracRepositoryInfo(int apiEpoch, int apiMajor, int apiMinor) {
        this(apiEpoch, apiMajor, apiMinor, null);
    }

    public TracRepositoryInfo(int apiEpoch, int apiMajor, int apiMinor, String version) {
        this.apiEpoch = apiEpoch;
        this.apiMajor = apiMajor;
        this.apiMinor = apiMinor;
        this.version = version;
    }

    public TracRepositoryInfo(String version) {
        this(-1, -1, -1, version);
    }

    public int getApiEpoch() {
        return this.apiEpoch;
    }

    public int getApiMajor() {
        return this.apiMajor;
    }

    public int getApiMinor() {
        return this.apiMinor;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isApiVersion(int epoch, int major, int minor) {
        return this.apiEpoch == epoch && this.apiMajor == major && this.apiMinor == minor;
    }

    public boolean isApiVersionOrHigher(int epoch, int major, int minor) {
        return this.apiEpoch > epoch || this.apiEpoch == epoch && (this.apiMajor > major || this.apiMajor == major && this.apiMinor >= minor);
    }

    public boolean isApiVersionOrSmaller(int epoch, int major, int minor) {
        return this.apiEpoch < epoch || this.apiEpoch == epoch && (this.apiMajor < major || this.apiMajor == major && this.apiMinor <= minor);
    }

    public boolean isStale() {
        return this.apiEpoch == -1 || this.apiMajor == -1 || this.apiMinor == -1;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.apiEpoch);
        sb.append(".");
        sb.append(this.apiMajor);
        sb.append(".");
        sb.append(this.apiMinor);
        if (this.version != null) {
            sb.append(" (");
            sb.append(this.version);
            sb.append(")");
        }
        return sb.toString();
    }
}

