/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.tcp;

import org.eclipse.net4j.internal.tcp.TCPClientConnector;
import org.eclipse.net4j.internal.tcp.TCPConnector;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.spi.net4j.ConnectorFactory;

public class TCPConnectorFactory
extends ConnectorFactory {
    public static final String TYPE = "tcp";

    public TCPConnectorFactory() {
        super(TYPE);
    }

    protected TCPConnectorFactory(String type) {
        super(type);
    }

    public TCPConnector create(String description) {
        TCPUtil.ConnectorData data = new TCPUtil.ConnectorData(description);
        TCPConnector connector = this.createConnector();
        connector.setHost(data.getHost());
        connector.setPort(data.getPort());
        connector.setUserID(data.getUserID());
        return connector;
    }

    protected TCPConnector createConnector() {
        return new TCPClientConnector();
    }

    public String getDescriptionFor(Object object) {
        if (object instanceof ITCPConnector) {
            ITCPConnector connector = (ITCPConnector)object;
            return new TCPUtil.ConnectorData(connector).toString();
        }
        return null;
    }
}

