/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldAccessSpec;
import org.eclipse.jdt.core.dom.GuardPredicateDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IMethodMappingBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodMappingElement;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.rewrite.ASTNodeCreator;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.core.manipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.UnresolvedElementsSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.NewMethodCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.compiler.InferenceKind;
import org.eclipse.objectteams.otdt.core.compiler.OTNameUtils;
import org.eclipse.objectteams.otdt.core.compiler.Pair;
import org.eclipse.objectteams.otdt.internal.ui.assist.OTQuickFixes;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.AddMethodMappingSignaturesProposal;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.RemoveMethodMappingSignaturesProposal;
import org.eclipse.text.edits.TextEditGroup;

public class MappingProposalSubProcessor {
    public static final String FAKETHIS = "$fakethis$";
    private static final String FAKED_METHOD = "$$faked$$";

    static ICommandAccess getChangeAssignmentToCalloutCallProposal(ICompilationUnit cu, TypeDeclaration enclosingType, ASTNode selectedNode) {
        Pair<SimpleName, Boolean> answer = MappingProposalSubProcessor.findFieldName(selectedNode);
        if (answer == null) {
            return null;
        }
        char[] accessorName = OTNameUtils.accessorName((boolean)true, (char[])((SimpleName)answer.first).getIdentifier().toCharArray());
        ASTNode parent = selectedNode.getParent();
        if (parent.getNodeType() != 7) {
            return null;
        }
        Assignment assignment = (Assignment)parent;
        AST ast = selectedNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        MethodInvocation send = ast.newMethodInvocation();
        if (((Boolean)answer.second).booleanValue()) {
            send.setExpression((Expression)ast.newThisExpression());
        }
        send.setName(ast.newSimpleName(String.valueOf(accessorName)));
        send.arguments().add(ASTNode.copySubtree((AST)ast, (ASTNode)assignment.getRightHandSide()));
        MappingProposalSubProcessor.makeReplacement(rewrite, (ASTNode)assignment, (ASTNode)send);
        ASTRewriteCorrectionProposal proposal = MappingProposalSubProcessor.getMaterializeInferredCalloutToFieldProposal(cu, rewrite, selectedNode, enclosingType, InferenceKind.FIELDSET);
        if (proposal != null) {
            return proposal;
        }
        return new ASTRewriteCorrectionProposal(CorrectionMessages.OTQuickfix_change_assignment_to_settercall, cu, rewrite, 10000, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
    }

    static ICommandAccess getChangeFieldReadToCalloutCallProposal(ICompilationUnit cu, TypeDeclaration enclosingType, ASTNode selectedNode) {
        Pair<SimpleName, Boolean> answer = MappingProposalSubProcessor.findFieldName(selectedNode);
        if (answer == null) {
            return null;
        }
        char[] accessorName = OTNameUtils.accessorName((boolean)false, (char[])((SimpleName)answer.first).getIdentifier().toCharArray());
        AST ast = selectedNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        MethodInvocation send = ast.newMethodInvocation();
        if (((Boolean)answer.second).booleanValue()) {
            send.setExpression((Expression)ast.newThisExpression());
        }
        send.setName(ast.newSimpleName(String.valueOf(accessorName)));
        MappingProposalSubProcessor.makeReplacement(rewrite, selectedNode, (ASTNode)send);
        ASTRewriteCorrectionProposal proposal = MappingProposalSubProcessor.getMaterializeInferredCalloutToFieldProposal(cu, rewrite, selectedNode, enclosingType, InferenceKind.FIELDGET);
        if (proposal != null) {
            return proposal;
        }
        return new ASTRewriteCorrectionProposal(CorrectionMessages.OTQuickfix_change_fieldaccess_to_gettercall, cu, rewrite, 10000, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
    }

    private static Pair<SimpleName, Boolean> findFieldName(ASTNode selectedNode) {
        switch (selectedNode.getNodeType()) {
            case 42: {
                return new Pair((Object)((SimpleName)selectedNode), (Object)false);
            }
            case 22: {
                FieldAccess access = (FieldAccess)selectedNode;
                if (access.getExpression().getNodeType() != 52) {
                    return null;
                }
                return new Pair((Object)access.getName(), (Object)true);
            }
        }
        return null;
    }

    private static void makeReplacement(ASTRewrite rewrite, ASTNode oldNode, ASTNode newNode) {
        ASTNode parent = oldNode.getParent();
        StructuralPropertyDescriptor desc = oldNode.getLocationInParent();
        if (desc.isChildListProperty()) {
            ListRewrite listRewrite = rewrite.getListRewrite(parent, (ChildListPropertyDescriptor)desc);
            listRewrite.replace(oldNode, newNode, null);
        } else {
            rewrite.set(parent, desc, (Object)newNode, null);
        }
    }

    static ASTRewriteCorrectionProposal getMaterializeInferredCalloutSelfCallProposal(ICompilationUnit cu, TypeDeclaration enclosingType, MethodInvocation selectedNode) throws JavaModelException {
        final IMethodBinding resolvedMethod = selectedNode.resolveMethodBinding();
        if (resolvedMethod == null) {
            return null;
        }
        IMethodMemento memento = new IMethodMemento(){

            @Override
            public boolean isEqualTo(IMethodBinding other) {
                return resolvedMethod.equals((Object)other);
            }
        };
        return MappingProposalSubProcessor.getMaterializeInferredCalloutProposal(cu, null, enclosingType, memento, InferenceKind.SELFCALL);
    }

    static ASTRewriteCorrectionProposal getMaterializeInferredCalloutToFieldProposal(ICompilationUnit cu, ASTRewrite rewrite, ASTNode selectedNode, TypeDeclaration enclosingType, final InferenceKind kind) {
        Pair<SimpleName, Boolean> answer = MappingProposalSubProcessor.findFieldName(selectedNode);
        if (answer == null) {
            return null;
        }
        final String accessorName = String.valueOf(OTNameUtils.accessorName((kind == InferenceKind.FIELDSET ? 1 : 0) != 0, (char[])((SimpleName)answer.first).getIdentifier().toCharArray()));
        final ITypeBinding fieldType = ((SimpleName)answer.first).resolveTypeBinding();
        IMethodMemento memento = new IMethodMemento(){

            @Override
            public boolean isEqualTo(IMethodBinding other) {
                if (!accessorName.equals(other.getName())) {
                    return false;
                }
                ITypeBinding returnType = other.getReturnType();
                ITypeBinding[] params = other.getParameterTypes();
                if (kind == InferenceKind.FIELDSET) {
                    if (!Bindings.isVoidType((ITypeBinding)returnType)) {
                        return false;
                    }
                    if (params.length != 1) {
                        return false;
                    }
                    return fieldType == null || params[0].equals((Object)fieldType);
                }
                if (Bindings.isVoidType((ITypeBinding)returnType)) {
                    return false;
                }
                if (fieldType != null && !fieldType.equals((Object)returnType)) {
                    return false;
                }
                return params.length == 0;
            }
        };
        return MappingProposalSubProcessor.getMaterializeInferredCalloutProposal(cu, rewrite, enclosingType, memento, kind);
    }

    static ASTRewriteCorrectionProposal getMaterializeInferredCalloutProposal(ICompilationUnit cu, ASTRewrite rewrite, TypeDeclaration enclosingType, IMethodMemento roleMethodMemento, InferenceKind kind) {
        ITypeBinding declaringClass = enclosingType.resolveBinding();
        IMethodMappingBinding[] iMethodMappingBindingArray = declaringClass.getResolvedMethodMappings();
        int n = iMethodMappingBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodMappingBinding mapping = iMethodMappingBindingArray[n2];
            if (mapping != null && mapping.getInferenceKind() == kind && roleMethodMemento.isEqualTo(mapping.getRoleMethod())) {
                return MappingProposalSubProcessor.createMaterializeInferredCalloutProposal(cu, rewrite, enclosingType, mapping, kind);
            }
            ++n2;
        }
        return null;
    }

    static ASTRewriteCorrectionProposal createMaterializeInferredCalloutProposal(ICompilationUnit cu, ASTRewrite rewrite, TypeDeclaration enclosingType, IMethodMappingBinding mapping, InferenceKind kind) {
        ImportRewrite imports;
        AST ast = enclosingType.getAST();
        try {
            imports = StubUtility.createImportRewrite((ICompilationUnit)cu, (boolean)true);
        }
        catch (JavaModelException jme) {
            return null;
        }
        CalloutMappingDeclaration callout = MappingProposalSubProcessor.createCalloutFromInferred(mapping, ast, imports, kind);
        if (rewrite == null) {
            rewrite = ASTRewrite.create((AST)ast);
        }
        rewrite.getListRewrite((ASTNode)enclosingType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY).insertFirst((ASTNode)callout, null);
        String label = kind == InferenceKind.SELFCALL ? CorrectionMessages.OTQuickfix_materialize_inferred_callout : CorrectionMessages.OTQuickfix_materialize_inferred_callout_to_field;
        ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(label, cu, rewrite, 10000, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
        proposal.setImportRewrite(imports);
        return proposal;
    }

    static ASTRewriteCorrectionProposal getMaterializeInferredCalloutsInheritedProposal(ICompilationUnit cu, TypeDeclaration enclosingType, ASTNode selectedNode) throws JavaModelException {
        AST ast = enclosingType.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)enclosingType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
        ImportRewrite imports = StubUtility.createImportRewrite((ICompilationUnit)cu, (boolean)true);
        boolean generated = false;
        ITypeBinding type = (ITypeBinding)((SimpleName)selectedNode).resolveBinding();
        IMethodMappingBinding[] iMethodMappingBindingArray = type.getResolvedMethodMappings();
        int n = iMethodMappingBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodMappingBinding mapping = iMethodMappingBindingArray[n2];
            if (!mapping.isCallin() && mapping.getInferenceKind() == InferenceKind.INTERFACE) {
                CalloutMappingDeclaration callout = MappingProposalSubProcessor.createCalloutFromInferred(mapping, ast, imports, InferenceKind.INTERFACE);
                listRewrite.insertFirst((ASTNode)callout, null);
                generated = true;
            }
            ++n2;
        }
        if (generated) {
            ASTRewriteCorrectionProposal proposal = new ASTRewriteCorrectionProposal(CorrectionMessages.OTQuickfix_materialize_inferred_callouts, cu, rewrite, 10000, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
            proposal.setImportRewrite(imports);
            return proposal;
        }
        return null;
    }

    static CalloutMappingDeclaration createCalloutFromInferred(IMethodMappingBinding mapping, AST ast, ImportRewrite imports, InferenceKind kind) {
        CalloutMappingDeclaration callout = ast.newCalloutMappingDeclaration();
        String[] argNames = mapping.getBaseArgumentNames();
        IMethodBinding[] baseMethods = mapping.getBaseMethods();
        IMethodBinding baseMethod = baseMethods.length > 0 ? baseMethods[0] : null;
        switch (kind) {
            case INTERFACE: 
            case SELFCALL: {
                callout.setBaseMappingElement((MethodMappingElement)MappingProposalSubProcessor.createMethodSpec(ast, imports, baseMethod, argNames));
                break;
            }
            case FIELDSET: {
                ITypeBinding fieldType;
                String fieldName;
                if (baseMethod != null) {
                    String baseMethodName = baseMethod.getName();
                    int pos = baseMethodName.lastIndexOf(36);
                    fieldName = baseMethodName.substring(pos + 1);
                    fieldType = baseMethod.getParameterTypes()[1];
                } else {
                    IVariableBinding baseField = mapping.getBaseField();
                    fieldName = baseField.getName();
                    fieldType = baseField.getType();
                }
                callout.setBaseMappingElement((MethodMappingElement)MappingProposalSubProcessor.createFieldSpec(ast, imports, fieldName, fieldType));
                callout.bindingOperator().setBindingModifier(524288);
                argNames = new String[]{fieldName};
                break;
            }
            case FIELDGET: {
                ITypeBinding fieldType;
                String fieldName;
                if (baseMethod != null) {
                    String baseMethodName = baseMethod.getName();
                    int pos = baseMethodName.lastIndexOf(36);
                    fieldName = baseMethodName.substring(pos + 1);
                    fieldType = baseMethod.getReturnType();
                } else {
                    IVariableBinding baseField = mapping.getBaseField();
                    fieldName = baseField.getName();
                    fieldType = baseField.getType();
                }
                callout.setBaseMappingElement((MethodMappingElement)MappingProposalSubProcessor.createFieldSpec(ast, imports, fieldName, fieldType));
                callout.bindingOperator().setBindingModifier(262144);
            }
        }
        callout.setRoleMappingElement((MethodMappingElement)MappingProposalSubProcessor.createMethodSpec(ast, imports, mapping.getRoleMethod(), argNames));
        callout.setSignatureFlag(true);
        return callout;
    }

    static MethodSpec createMethodSpec(AST ast, ImportRewrite imports, IMethodBinding methodBinding, String[] argNames) {
        ArrayList<SingleVariableDeclaration> args = new ArrayList<SingleVariableDeclaration>();
        int i = 0;
        while (i < methodBinding.getParameterTypes().length) {
            ITypeBinding paramType = methodBinding.getParameterTypes()[i];
            args.add(ASTNodeCreator.createArgument((AST)ast, (int)0, (Type)imports.addImport(paramType, ast), (String)argNames[i], null));
            ++i;
        }
        ITypeBinding providedReturnType = methodBinding.getReturnType();
        Type returnType = imports.addImport(providedReturnType, ast);
        return ASTNodeCreator.createMethodSpec((AST)ast, (String)methodBinding.getName(), (Type)returnType, args, (boolean)true);
    }

    static FieldAccessSpec createFieldSpec(AST ast, ImportRewrite imports, String fieldName, ITypeBinding fieldType) {
        return ASTNodeCreator.createFieldAccSpec((AST)ast, (String)fieldName, (Type)imports.addImport(fieldType, ast));
    }

    public static ICommandAccess addTypeParameterToCallin(ICompilationUnit cu, ASTNode selectedNode, TypeDeclaration enclosingType) {
        String TYPE_VAR_NAME = "E";
        if (selectedNode instanceof Name) {
            MethodSpec roleSpec = (MethodSpec)ASTNodes.getParent((ASTNode)selectedNode, (int)100);
            ASTNode oldType = selectedNode.getParent();
            IMethodBinding roleMethod = roleSpec.resolveBinding();
            MethodDeclaration roleMethodDecl = null;
            MethodDeclaration[] methodDeclarationArray = enclosingType.getMethods();
            int n = methodDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDeclaration method = methodDeclarationArray[n2];
                if (method.resolveBinding() == roleMethod) {
                    Name typeName;
                    Type returnType = method.getReturnType2();
                    if (returnType == null || returnType.isSimpleType() && "void".equals((typeName = ((SimpleType)returnType).getName()).getFullyQualifiedName())) break;
                    roleMethodDecl = method;
                    break;
                }
                ++n2;
            }
            AST ast = enclosingType.getAST();
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            TextEditGroup group = new TextEditGroup("adding parameter");
            TypeParameter typeParameter = ast.newTypeParameter();
            typeParameter.setName(ast.newSimpleName("E"));
            typeParameter.typeBounds().add(ASTNode.copySubtree((AST)ast, (ASTNode)oldType));
            rewrite.getListRewrite((ASTNode)roleSpec, MethodSpec.TYPE_PARAMETERS_PROPERTY).insertFirst((ASTNode)typeParameter, group);
            rewrite.set((ASTNode)roleSpec, (StructuralPropertyDescriptor)MethodSpec.RETURN_TYPE2_PROPERTY, (Object)ast.newSimpleType((Name)ast.newSimpleName("E")), group);
            if (roleMethodDecl != null) {
                rewrite.getListRewrite((ASTNode)roleMethodDecl, MethodDeclaration.TYPE_PARAMETERS_PROPERTY).insertFirst(ASTNode.copySubtree((AST)ast, (ASTNode)typeParameter), group);
                rewrite.set((ASTNode)roleMethodDecl, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)ast.newSimpleType((Name)ast.newSimpleName("E")), group);
            }
            return new ASTRewriteCorrectionProposal(CorrectionMessages.OTQuickfix_addtypeparametertocallin_label, cu, rewrite, 10000, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
        }
        return null;
    }

    public static void addUnresolvedMethodSpecProposals(ASTNode selectedNode, TypeDeclaration enclosingType, IInvocationContext context, final IProblemLocation problem, Collection proposals) throws CoreException {
        AST ast = selectedNode.getAST();
        while (selectedNode.getNodeType() != 100) {
            if ((selectedNode = selectedNode.getParent()) != null) continue;
            return;
        }
        MethodSpec methodSpec = (MethodSpec)selectedNode;
        MethodDeclaration fakeMethod = ast.newFakedMethodDeclaration(enclosingType);
        fakeMethod.setName(ast.newSimpleName(FAKED_METHOD));
        ASTNode mapping = methodSpec.getParent();
        fakeMethod.setSourceRange(mapping.getStartPosition(), mapping.getLength());
        MethodInvocation invoc = ast.newMethodInvocation();
        invoc.setSourceRange(methodSpec.getStartPosition(), methodSpec.getLength());
        StructuralPropertyDescriptor locationInParent = methodSpec.getLocationInParent();
        if (locationInParent == CalloutMappingDeclaration.BASE_MAPPING_ELEMENT_PROPERTY || locationInParent == CallinMappingDeclaration.BASE_MAPPING_ELEMENTS_PROPERTY) {
            if (enclosingType.getNodeType() == 109) {
                Type baseType = ((RoleTypeDeclaration)enclosingType).getBaseClassType();
                invoc.setExpression((Expression)ast.newResolvedVariableName(new String(IOTConstants._OT_BASE_ARG), baseType));
            }
        } else {
            invoc.setExpression((Expression)ast.newResolvedVariableName(FAKETHIS, enclosingType));
        }
        final SimpleName selector = (SimpleName)ASTNode.copySubtree((AST)ast, (ASTNode)methodSpec.getName());
        selector.setSourceRange(methodSpec.getName().getStartPosition(), methodSpec.getName().getLength());
        invoc.setName(selector);
        for (Object elem : methodSpec.parameters()) {
            SingleVariableDeclaration param = (SingleVariableDeclaration)elem;
            fakeMethod.parameters().add(ASTNode.copySubtree((AST)ast, (ASTNode)param));
            invoc.arguments().add(ast.newSimpleName(param.getName().getIdentifier()));
        }
        fakeMethod.setBody(ast.newBlock());
        fakeMethod.getBody().statements().add(ast.newExpressionStatement((Expression)invoc));
        IProblemLocation newProblem = new IProblemLocation(){

            public ASTNode getCoveredNode(CompilationUnit astRoot) {
                return selector;
            }

            public ASTNode getCoveringNode(CompilationUnit astRoot) {
                return selector;
            }

            public int getLength() {
                return selector.getLength();
            }

            public String getMarkerType() {
                return problem.getMarkerType();
            }

            public int getOffset() {
                return selector.getStartPosition();
            }

            public String[] getProblemArguments() {
                return problem.getProblemArguments();
            }

            public int getProblemId() {
                return problem.getProblemId();
            }

            public boolean isError() {
                return true;
            }
        };
        UnresolvedElementsSubProcessor.getMethodProposals((IInvocationContext)context, (IProblemLocation)newProblem, (problem.getProblemId() == 1401008 ? 1 : 0) != 0, (Collection)proposals);
        for (Object proposal : proposals) {
            if (!(proposal instanceof NewMethodCorrectionProposal)) continue;
            NewMethodCorrectionProposal methodProposal = (NewMethodCorrectionProposal)proposal;
            OTQuickFixes.instance().registerNewMethodCorrectionProposal(methodSpec, methodProposal);
            methodProposal.setDisplayName(MappingProposalSubProcessor.updateDisplayName(methodSpec, methodProposal.getDisplayString()));
        }
    }

    private static String updateDisplayName(MethodSpec methodSpec, String displayString) {
        String head = displayString.substring(0, displayString.indexOf(40) + 1);
        String tail = displayString.substring(displayString.indexOf(41));
        StringBuffer buf = new StringBuffer(head);
        List parameters = methodSpec.parameters();
        String sep = "";
        int i = 0;
        while (i < parameters.size()) {
            buf.append(sep);
            SingleVariableDeclaration arg = (SingleVariableDeclaration)parameters.get(i);
            buf.append(arg.getType().toString());
            sep = ", ";
            ++i;
        }
        buf.append(tail);
        return buf.toString();
    }

    public static void getAddMethodMappingSignaturesProposal(ICompilationUnit cu, ASTNode coveringNode, int relevance, Collection<ICommandAccess> resultingCollections) {
        AbstractMethodMappingDeclaration mapping = MappingProposalSubProcessor.getMethodMapping(coveringNode);
        if (mapping != null && !mapping.hasSignature()) {
            resultingCollections.add((ICommandAccess)new AddMethodMappingSignaturesProposal(cu, mapping, relevance));
        }
    }

    public static void getRemoveMethodMappingSignaturesProposal(ICompilationUnit cu, ASTNode coveringNode, int relevance, Collection<ICommandAccess> resultingCollections) {
        AbstractMethodMappingDeclaration mapping = MappingProposalSubProcessor.getMethodMapping(coveringNode);
        if (mapping != null && mapping.hasSignature()) {
            if (mapping.getNodeType() == 101 && MappingProposalSubProcessor.predicateUsesMethodSpecArgument((CallinMappingDeclaration)mapping)) {
                return;
            }
            resultingCollections.add((ICommandAccess)new RemoveMethodMappingSignaturesProposal(cu, mapping, relevance));
        }
    }

    private static AbstractMethodMappingDeclaration getMethodMapping(ASTNode coveringNode) {
        if (coveringNode instanceof AbstractMethodMappingDeclaration) {
            return (AbstractMethodMappingDeclaration)coveringNode;
        }
        return (AbstractMethodMappingDeclaration)ASTNodes.getParent((ASTNode)coveringNode, AbstractMethodMappingDeclaration.class);
    }

    private static boolean predicateUsesMethodSpecArgument(CallinMappingDeclaration callinMapping) {
        GuardPredicateDeclaration predicate = callinMapping.getGuardPredicate();
        if (predicate == null) {
            return false;
        }
        final ArrayList<String> argNames = new ArrayList<String>();
        if (predicate.isBase()) {
            for (Object baseMethodObject : callinMapping.getBaseMappingElements()) {
                for (Object baseArgObj : ((MethodSpec)baseMethodObject).parameters()) {
                    argNames.add(((SingleVariableDeclaration)baseArgObj).getName().getIdentifier());
                }
            }
        } else {
            for (Object roleArgObj : ((MethodSpec)callinMapping.getRoleMappingElement()).parameters()) {
                argNames.add(((SingleVariableDeclaration)roleArgObj).getName().getIdentifier());
            }
        }
        try {
            predicate.getExpression().accept(new ASTVisitor(){

                public boolean visit(SimpleName node) {
                    for (String argName : argNames) {
                        if (!argName.equals(node.getIdentifier())) continue;
                        throw new RuntimeException();
                    }
                    return false;
                }
            });
        }
        catch (RuntimeException re) {
            return true;
        }
        return false;
    }

    static interface IMethodMemento {
        public boolean isEqualTo(IMethodBinding var1);
    }
}

