/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.WildcardType;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.resource.AS2ID;
import org.eclipse.ocl.pivot.internal.resource.LUSSIDs;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.Unlimited;

public class PivotLUSSIDs
extends LUSSIDs {
    private Package typeOrphanage = null;
    private Class featureOrphanage = null;

    public PivotLUSSIDs(@NonNull ASResource asResource, @NonNull Map<@NonNull Object, @Nullable Object> options) {
        super(asResource, options);
        block0: for (EObject eRoot : asResource.getContents()) {
            if (!(eRoot instanceof Model)) continue;
            for (Package asPackage : ((Model)eRoot).getOwnedPackages()) {
                if (!Orphanage.isTypeOrphanage(asPackage)) continue;
                this.typeOrphanage = asPackage;
                this.featureOrphanage = NameUtil.getNameable(asPackage.getOwnedClasses(), "$$");
                break block0;
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    protected @Nullable Integer computeLocalLUSSID(@NonNull AS2ID as2id, @NonNull EObject element, boolean normalizeTemplateParameters) {
        Property property;
        assert (this.asResource == element.eResource());
        int localId = 0;
        if (!(element instanceof NamedElement)) {
            return null;
        }
        String name = ((NamedElement)element).getName();
        if (name == null) {
            return null;
        }
        localId += name.hashCode();
        if (element instanceof TemplateableElement) {
            for (TemplateBinding templateBinding : PivotUtil.getOwnedBindings((TemplateableElement)element)) {
                for (TemplateParameterSubstitution templateParameterSubstitution : PivotUtil.getOwnedSubstitutions(templateBinding)) {
                    Type actual = templateParameterSubstitution.getActual();
                    if (actual instanceof WildcardType) {
                        localId += 89;
                        continue;
                    }
                    if (actual instanceof Type) {
                        localId += 89 * this.computeReferenceLUSSID(as2id, actual, normalizeTemplateParameters);
                        continue;
                    }
                    if (actual == null) continue;
                    localId += 89 * as2id.assignLUSSID(actual, false, normalizeTemplateParameters);
                }
            }
            if (element instanceof CollectionType) {
                Number upper;
                int lowerValue;
                CollectionType collectionType = (CollectionType)element;
                if (!collectionType.isIsNullFree()) {
                    localId += 59;
                }
                if ((lowerValue = collectionType.getLower().intValue()) != 0) {
                    localId += 61 * lowerValue;
                }
                if (!((upper = collectionType.getUpper()) instanceof Unlimited)) {
                    localId += 67 * upper.intValue();
                }
            } else if (element instanceof LambdaType) {
                LambdaType lambdaType = (LambdaType)element;
                localId += 71 * this.computeReferenceLUSSID(as2id, PivotUtil.getContextType(lambdaType), normalizeTemplateParameters);
                int lambdaTypeParameterTypeMultiplier = 73;
                for (Type parameterType : PivotUtil.getParameterType(lambdaType)) {
                    localId += lambdaTypeParameterTypeMultiplier * this.computeReferenceLUSSID(as2id, parameterType, normalizeTemplateParameters);
                    lambdaTypeParameterTypeMultiplier += 73;
                }
                localId += 79 * this.computeReferenceLUSSID(as2id, PivotUtil.getResultType(lambdaType), normalizeTemplateParameters);
            } else if (element instanceof Iteration) {
                @NonNull Iterable parameters = Iterables.concat(PivotUtil.getOwnedIterators((Iteration)element), PivotUtil.getOwnedAccumulators((Iteration)element));
                localId += this.computeParametersLUSSID(as2id, parameters);
            } else if (element instanceof Operation) {
                localId += this.computeParametersLUSSID(as2id, PivotUtil.getOwnedParameters((Operation)element));
            }
        } else if (element instanceof Property && (property = (Property)element).isIsImplicit()) {
            Property oppositeProperty = property.getOpposite();
            if (oppositeProperty != null) {
                String oppositeName = oppositeProperty.getName();
                if (oppositeName != null) {
                    localId += 7 * oppositeName.hashCode();
                }
            } else {
                System.out.println("No opposite for " + element);
            }
        }
        return localId;
    }

    protected int computeParametersLUSSID(@NonNull AS2ID as2id, @NonNull Iterable<@NonNull Parameter> parameters) {
        int parametersLUSSID = 0;
        int parameterIndex = 1;
        for (Parameter parameter : parameters) {
            TemplateSignature templateSignature;
            int index = -1;
            Type parameterType = parameter.getType();
            if (parameterType instanceof TemplateParameter && (templateSignature = ((TemplateParameter)parameterType).getOwningSignature()) != null) {
                List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
                index = templateParameters.indexOf(parameterType);
            }
            if (index >= 0) {
                parametersLUSSID += parameterIndex * 97 * (index + 1);
            } else if (parameterType != null) {
                parametersLUSSID += parameterIndex * 83 * this.computeReferenceLUSSID(as2id, parameterType, true);
            }
            ++parameterIndex;
        }
        return parametersLUSSID;
    }

    protected int computeReferenceLUSSID(@NonNull AS2ID as2id, @NonNull Type type, boolean normalizeTemplateParameters) {
        if (normalizeTemplateParameters && type instanceof TemplateParameter) {
            boolean gotIt = false;
            int index = 0;
            EObject eContainer = type.eContainer();
            while (eContainer != null) {
                TemplateSignature templateSignature;
                if (eContainer instanceof TemplateableElement && (templateSignature = ((TemplateableElement)eContainer).getOwnedSignature()) != null) {
                    List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
                    int localIndex = templateParameters.indexOf(type);
                    if (localIndex >= 0) {
                        index += localIndex;
                        gotIt = true;
                    } else {
                        index += templateParameters.size();
                    }
                }
                eContainer = eContainer.eContainer();
            }
            if (gotIt) {
                return 97 * index;
            }
        }
        return as2id.assignLUSSID(type, false, true);
    }

    @Override
    protected boolean isExternallyReferenceable(@NonNull EObject eObject) {
        if (eObject instanceof Type) {
            if (this.typeOrphanage == null || eObject.eContainer() != this.typeOrphanage) {
                return true;
            }
        } else if (eObject instanceof Package) {
            if (eObject != this.typeOrphanage) {
                return true;
            }
        } else if (eObject instanceof Feature) {
            if (this.featureOrphanage == null || eObject.eContainer() != this.featureOrphanage) {
                return true;
            }
        } else {
            if (eObject instanceof Constraint) {
                return true;
            }
            if (eObject instanceof EnumerationLiteral) {
                return true;
            }
            if (eObject instanceof Model) {
                return true;
            }
        }
        return false;
    }
}

