/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.builder;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.xtext.base.ui.BaseUIActivator;
import org.eclipse.ocl.xtext.base.ui.builder.AbstractBuildSelector;
import org.eclipse.ocl.xtext.base.ui.messages.BaseUIMessages;

public abstract class AbstractValidatingBuilder
extends IncrementalProjectBuilder {
    static final boolean isExcluded(char[] path, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean isFolderPath) {
        int length;
        int i;
        block9: {
            if (inclusionPatterns == null && exclusionPatterns == null) {
                return false;
            }
            if (inclusionPatterns != null) {
                i = 0;
                length = inclusionPatterns.length;
                while (i < length) {
                    int star;
                    int lastSlash;
                    char[] pattern;
                    char[] folderPattern = pattern = inclusionPatterns[i];
                    if (isFolderPath && (lastSlash = CharOperation.lastIndexOf((char)'/', (char[])pattern)) != -1 && lastSlash != pattern.length - 1 && ((star = CharOperation.indexOf((char)'*', (char[])pattern, (int)lastSlash)) == -1 || star >= pattern.length - 1 || pattern[star + 1] != '*')) {
                        folderPattern = CharOperation.subarray((char[])pattern, (int)0, (int)lastSlash);
                    }
                    if (!CharOperation.pathMatch((char[])folderPattern, (char[])path, (boolean)true, (char)'/')) {
                        ++i;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (isFolderPath) {
            path = CharOperation.concat((char[])path, (char[])new char[]{'*'}, (char)'/');
        }
        if (exclusionPatterns != null) {
            i = 0;
            length = exclusionPatterns.length;
            while (i < length) {
                if (CharOperation.pathMatch((char[])exclusionPatterns[i], (char[])path, (boolean)true, (char)'/')) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        assert (project != null);
        try {
            try {
                IResourceDelta delta;
                AbstractBuildSelector buildSelector;
                String builderName = this.getBuilderName();
                String projectName = project.getName();
                String initializingMessage = StringUtil.bind((String)BaseUIMessages.MultiValidationJob_Initializing, (Object[])new Object[]{builderName, projectName});
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)initializingMessage, (int)3);
                if (kind == 6) {
                    buildSelector = this.createBuildSelector(project, BuildType.FULL, args, (IProgressMonitor)subMonitor);
                    delta = null;
                } else {
                    delta = this.getDelta(this.getProject());
                    buildSelector = this.createBuildSelector(project, BuildType.INCREMENTAL, args, (IProgressMonitor)subMonitor);
                }
                subMonitor.worked(1);
                String selectingMessage = StringUtil.bind((String)BaseUIMessages.MultiValidationJob_Selecting, (Object[])new Object[]{builderName, projectName});
                subMonitor.subTask(selectingMessage);
                int selectionSize = buildSelector.selectResources(delta);
                subMonitor.worked(1);
                if (selectionSize > 0) {
                    String queueingMessage = StringUtil.bind((String)BaseUIMessages.MultiValidationJob_Queuing, (Object[])new Object[]{builderName, selectionSize, projectName});
                    subMonitor.subTask(queueingMessage);
                    buildSelector.buildResources();
                    subMonitor.worked(1);
                }
                subMonitor.done();
                return null;
            }
            catch (CoreException e) {
                this.getLog().error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (OperationCanceledException e) {
                this.handleCanceled(e);
                if (monitor == null) return null;
                monitor.done();
                return null;
            }
            catch (Exception e) {
                this.getLog().error((Object)e.getMessage(), (Throwable)e);
                this.forgetLastBuiltState();
                if (monitor == null) return null;
                monitor.done();
                return null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
    }

    protected @NonNull AbstractBuildSelector createBuildSelector(@NonNull IProject project, @NonNull BuildType buildType, @Nullable Map<String, String> args, @NonNull IProgressMonitor monitor) {
        return new BuildSelector(this.getBuilderName(), project, buildType, args, monitor);
    }

    protected abstract @NonNull String getBuilderName();

    protected abstract Logger getLog();

    private void handleCanceled(Throwable t) {
        BaseUIActivator.cancelMultiValidationJob();
    }

    @Deprecated
    public static class BuildSelector
    extends AbstractBuildSelector {
        public BuildSelector(@NonNull String builderName, @NonNull IProject project, @NonNull BuildType buildType, Map<String, String> args, @NonNull IProgressMonitor monitor) {
            super(project, buildType, args, monitor);
        }
    }

    protected static enum BuildType {
        CLEAN,
        FULL,
        INCREMENTAL,
        RECOVERY;

    }
}

