/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import java.io.IOException;
import lpg.runtime.LpgLexStream;
import org.eclipse.ocl.lpg.BasicEnvironment;

public abstract class DerivedLexStream
extends LpgLexStream {
    protected static final int ECLIPSE_TAB_VALUE = 4;
    private BasicEnvironment environment;

    public DerivedLexStream(BasicEnvironment environment, String filename, int tab) throws IOException {
        super(filename, tab);
        this.environment = environment;
    }

    public DerivedLexStream(BasicEnvironment environment, char[] input_chars, String filename, int tab) {
        super(input_chars, filename, tab);
        this.environment = environment;
    }

    public DerivedLexStream() {
        this.setTab(4);
    }

    protected int computeErrorCode(int leftToken, int rightToken) {
        if (rightToken >= this.getStreamLength()) {
            return 10;
        }
        if (leftToken == rightToken) {
            return 0;
        }
        return 11;
    }

    public void initialize(char[] inputChars) {
        this.setInputChars(inputChars);
        this.setStreamLength(inputChars.length);
        this.computeLineOffsets();
    }

    public void reportLexicalError(int errorCode, int leftLoc, int rightLoc, int errorLeftLoc, int errorRightLoc, String[] errorInfo) {
        BasicEnvironment environment = this.environment;
        if (environment != null) {
            environment.lexerError(errorCode, leftLoc, rightLoc);
        } else {
            super.reportLexicalError(errorCode, leftLoc, rightLoc, errorLeftLoc, errorRightLoc, errorInfo);
        }
    }
}

