/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.util;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.oomph.setup.log.ProgressLog;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;

public final class DownloadUtil {
    private static final int RETRY_DELAY = 2000;
    private static final int HTTP_ERROR_BASE_CODE = 400;
    private static final int DOWNLOAD_TIMEOUT = 30000;
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 30000;
    private static final int BUFFER_SIZE = 4096;

    private DownloadUtil() {
    }

    public static File downloadURL(String url, ProgressLog progress) {
        String normalizedURL = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
        try {
            String name = DownloadUtil.encodeFilename(url);
            File tmp = File.createTempFile(String.valueOf(name) + "-", ".part");
            File file = new File(tmp.getParentFile(), String.valueOf(name) + ".zip");
            if (!file.exists()) {
                try {
                    DownloadUtil.downloadURL(normalizedURL, tmp, progress);
                }
                catch (Exception ex) {
                    if (tmp.exists() && !tmp.delete()) {
                        tmp.deleteOnExit();
                    }
                    throw ex;
                }
                tmp.renameTo(file);
            }
            return file;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void downloadURL(String url, File file, ProgressLog progress) {
        byte[] data = new byte[4096];
        BufferedInputStream in = null;
        FileOutputStream out = null;
        try {
            try {
                SocketTimeoutException exception = null;
                String fileName = file.getName();
                float factor = 0.0f;
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() < start + 30000L) {
                    exception = null;
                    try {
                        URLConnection connection = new URL(url).openConnection();
                        connection.setConnectTimeout(10000 - (int)(System.currentTimeMillis() - start));
                        connection.setReadTimeout(30000);
                        if (connection instanceof HttpURLConnection) {
                            connection.connect();
                            int result = ((HttpURLConnection)connection).getResponseCode();
                            if (result >= 400) {
                                throw new IOException("HTTP error " + result);
                            }
                        }
                        int length = connection.getContentLength();
                        factor = 100.0f / (float)length;
                        fileName = new File(connection.getURL().getFile()).getName();
                        in = new BufferedInputStream(connection.getInputStream());
                        break;
                    }
                    catch (SocketTimeoutException ex) {
                        exception = ex;
                        progress.log("Connection timed out. Retrying in 2 seconds...");
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw ex;
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
                out = new FileOutputStream(file);
                int lastPercent = 0;
                int read = 0;
                while (true) {
                    int n;
                    block15: {
                        long startRead = System.currentTimeMillis();
                        try {
                            n = in.read(data, 0, 4096);
                            if (n != -1) break block15;
                            break;
                        }
                        catch (SocketTimeoutException ex) {
                            progress.log("Timeout during read after " + (System.currentTimeMillis() - startRead) + " millis");
                            throw ex;
                        }
                    }
                    out.write(data, 0, n);
                    int percent = Math.round(factor * (float)(read += n));
                    if (percent == lastPercent) continue;
                    progress.log("Downloading " + fileName + " (" + percent + "%)");
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Problem downloading '" + url + "'", ex);
            }
        }
        catch (Throwable throwable) {
            OS.close(out);
            OS.close(in);
            throw throwable;
        }
        OS.close((Closeable)out);
        OS.close((Closeable)in);
    }

    private static String encodeFilename(String url) {
        StringBuilder builder = new StringBuilder(url);
        int i = 0;
        while (i < builder.length()) {
            char c = builder.charAt(i);
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                builder.setCharAt(i, '_');
            }
            ++i;
        }
        return builder.toString();
    }

    public static String load(URIConverter uriConverter, URI uri, String encoding) throws IOException {
        String string;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(uriConverter.createInputStream(uri));
            byte[] input = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(input);
            if (encoding == null) {
                Map contentDescription = uriConverter.contentDescription(uri, Collections.singletonMap("REQUESTED_PROPERTIES", Collections.singleton("org.eclipse.emf.ecore:contentType")));
                encoding = (String)contentDescription.get("org.eclipse.core.runtime:charset");
            }
            string = encoding == null ? new String(input) : new String(input, encoding);
        }
        catch (Throwable throwable) {
            IOUtil.close(bufferedInputStream);
            throw throwable;
        }
        IOUtil.close((Closeable)bufferedInputStream);
        return string;
    }
}

