/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.expressions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class ServiceRegistryPropertyTester
extends PropertyTester {
    private static final String PROPERTY_HAS_SEMANTIC_MODEL = "hasSemanticModel";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result;
        switch (property) {
            case "hasSemanticModel": {
                result = this.hasSemanticModel((ServicesRegistry)TypeUtils.as((Object)receiver, ServicesRegistry.class));
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    protected boolean hasSemanticModel(ServicesRegistry services) {
        boolean result = false;
        try {
            ModelSet modelSet = services.getService(ModelSet.class);
            result = !ILanguageService.getLanguageModels(modelSet).isEmpty();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return result;
    }
}

