/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IExtensionDeltaListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.IStateDeltaListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.WorkspacePluginModelManager;
import org.eclipse.pde.internal.core.target.P2TargetUtils;

public class PluginModelManager
implements IModelProviderListener {
    private static final String fExternalPluginListFile = "SavedExternalPluginList.txt";
    private static PluginModelManager fModelManager;
    private UpdateClasspathsJob fUpdateJob = new UpdateClasspathsJob();
    private ExternalModelManager fExternalManager;
    private WorkspacePluginModelManager fWorkspaceManager = new WorkspacePluginModelManager();
    private PDEState fState;
    private Map<String, LocalModelEntry> fEntries;
    private ArrayList<IPluginModelListener> fListeners;
    private ArrayList<IStateDeltaListener> fStateListeners;
    private boolean fCancelled = false;

    private PluginModelManager() {
        this.fExternalManager = new ExternalModelManager();
        this.fExternalManager.addModelProviderListener(this);
        this.fWorkspaceManager.addModelProviderListener(this);
    }

    public static synchronized PluginModelManager getInstance() {
        if (fModelManager == null) {
            fModelManager = new PluginModelManager();
        }
        return fModelManager;
    }

    public static synchronized void shutdownInstance() {
        if (fModelManager != null) {
            fModelManager.shutdown();
        }
    }

    @Override
    public void modelsChanged(IModelProviderEvent e) {
        IModel[] iModelArray;
        int n;
        PluginModelDelta delta = new PluginModelDelta();
        if ((e.getEventTypes() & 2) != 0) {
            IModel[] removed;
            IModel[] iModelArray2 = removed = e.getRemovedModels();
            n = removed.length;
            int n2 = 0;
            while (n2 < n) {
                IModel element = iModelArray2[n2];
                IPluginModelBase model = (IPluginModelBase)element;
                String id = model.getPluginBase().getId();
                if (id != null) {
                    this.handleRemove(id, model, delta);
                }
                ++n2;
            }
        }
        HashSet<String> addedBSNs = new HashSet<String>();
        if ((e.getEventTypes() & 1) != 0) {
            IModel[] added;
            iModelArray = added = e.getAddedModels();
            int n3 = added.length;
            n = 0;
            while (n < n3) {
                IModel element = iModelArray[n];
                IPluginModelBase model = (IPluginModelBase)element;
                String id = model.getPluginBase().getId();
                if (id != null) {
                    this.handleAdd(id, model, delta);
                    addedBSNs.add(id);
                }
                ++n;
            }
        }
        if ((e.getEventTypes() & 4) != 0) {
            IModel[] changed = e.getChangedModels();
            iModelArray = changed;
            int n4 = changed.length;
            n = 0;
            while (n < n4) {
                IModel element = iModelArray[n];
                this.handleChange((IPluginModelBase)element, delta);
                ++n;
            }
        }
        if (this.fState != null) {
            StateDelta stateDelta = null;
            stateDelta = addedBSNs.isEmpty() ? this.fState.resolveState(true) : this.fState.resolveState(addedBSNs.toArray(new String[addedBSNs.size()]));
            this.updateAffectedEntries(stateDelta, (e.getEventTypes() & 4) != 0);
            this.fireStateDelta(stateDelta);
        }
        this.fireDelta(delta);
    }

    private void updateAffectedEntries(StateDelta delta, boolean runAsynch) {
        int n;
        HashMap<IJavaProject, RequiredPluginsClasspathContainer> map = new HashMap<IJavaProject, RequiredPluginsClasspathContainer>();
        if (delta == null) {
            IPluginModelBase[] models;
            IPluginModelBase[] iPluginModelBaseArray = models = this.getWorkspaceModels();
            n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                IProject project = model.getUnderlyingResource().getProject();
                try {
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        map.put(JavaCore.create((IProject)project), new RequiredPluginsClasspathContainer(model));
                    }
                }
                catch (CoreException coreException) {}
                ++n2;
            }
        } else {
            IPluginModelBase[] models;
            BundleDelta[] deltas;
            BundleDelta[] bundleDeltaArray = deltas = delta.getChanges();
            n = deltas.length;
            int n3 = 0;
            while (n3 < n) {
                BundleDelta bundleDelta = bundleDeltaArray[n3];
                try {
                    IJavaProject jProject;
                    IProject project;
                    IResource resource;
                    IPluginModelBase model = this.findModel(bundleDelta.getBundle());
                    IResource iResource = resource = model == null ? null : model.getUnderlyingResource();
                    if (resource != null && (project = resource.getProject()).hasNature("org.eclipse.jdt.core.javanature") && !map.containsKey(jProject = JavaCore.create((IProject)project))) {
                        map.put(jProject, new RequiredPluginsClasspathContainer(model));
                    }
                }
                catch (CoreException coreException) {}
                ++n3;
            }
            IPluginModelBase[] iPluginModelBaseArray = models = this.getWorkspaceModels();
            int n4 = models.length;
            n = 0;
            while (n < n4) {
                IPluginModelBase model = iPluginModelBaseArray[n];
                IProject project = model.getUnderlyingResource().getProject();
                try {
                    IBuild build;
                    IJavaProject jProject;
                    if (project.hasNature("org.eclipse.jdt.core.javanature") && !map.containsKey(jProject = JavaCore.create((IProject)project)) && (build = ClasspathUtilCore.getBuild(model)) != null && build.getEntry("additional.bundles") != null) {
                        map.put(jProject, new RequiredPluginsClasspathContainer(model, build));
                    }
                }
                catch (CoreException coreException) {}
                ++n;
            }
        }
        if (!map.isEmpty()) {
            Iterator iterator = map.entrySet().iterator();
            IJavaProject[] projects = new IJavaProject[map.size()];
            IClasspathContainer[] containers = new IClasspathContainer[projects.length];
            int index = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                projects[index] = (IJavaProject)entry.getKey();
                containers[index] = (IClasspathContainer)entry.getValue();
                ++index;
            }
            if (runAsynch) {
                this.fUpdateJob.add(projects, containers);
                this.fUpdateJob.schedule();
            } else {
                try {
                    JavaCore.setClasspathContainer((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, (IJavaProject[])projects, (IClasspathContainer[])containers, null);
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }

    private void fireDelta(PluginModelDelta delta) {
        if (this.fListeners != null) {
            int i = 0;
            while (i < this.fListeners.size()) {
                this.fListeners.get(i).modelsChanged(delta);
                ++i;
            }
        }
    }

    private void fireStateDelta(StateDelta delta) {
        if (this.fStateListeners != null) {
            ListIterator<IStateDeltaListener> li = this.fStateListeners.listIterator();
            while (li.hasNext()) {
                li.next().stateResolved(delta);
            }
        }
    }

    private void fireStateChanged(PDEState newState) {
        if (this.fStateListeners != null) {
            ListIterator<IStateDeltaListener> li = this.fStateListeners.listIterator();
            while (li.hasNext()) {
                li.next().stateChanged(newState.getState());
            }
        }
    }

    public void addPluginModelListener(IPluginModelListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ArrayList();
        }
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void addStateDeltaListener(IStateDeltaListener listener) {
        if (this.fStateListeners == null) {
            this.fStateListeners = new ArrayList();
        }
        if (!this.fStateListeners.contains(listener)) {
            this.fStateListeners.add(listener);
        }
    }

    public void removePluginModelListener(IPluginModelListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove(listener);
        }
    }

    public void removeStateDeltaListener(IStateDeltaListener listener) {
        if (this.fStateListeners != null) {
            this.fStateListeners.remove(listener);
        }
    }

    public boolean isEmpty() {
        return this.getEntryTable().isEmpty();
    }

    public boolean isInitialized() {
        return this.fEntries != null;
    }

    public boolean isCancelled() {
        return this.fCancelled;
    }

    public void targetReloaded(IProgressMonitor monitor) {
        this.fEntries = null;
        this.initializeTable(monitor);
    }

    private Map<String, LocalModelEntry> getEntryTable() {
        this.initializeTable(null);
        return this.fEntries;
    }

    private synchronized void initializeTable(IProgressMonitor monitor) {
        if (this.fEntries != null) {
            return;
        }
        PlatformAdmin pAdmin = Platform.getPlatformAdmin();
        if (pAdmin == null) {
            PDECore.logErrorMessage(PDECoreMessages.PluginModelManager_PlatformAdminMissingErrorMessage);
            this.fEntries = Collections.emptyMap();
            return;
        }
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (String)PDECoreMessages.PluginModelManager_InitializingPluginModels, (int)100);
        if (PDECore.DEBUG_MODEL) {
            if (this.fState == null) {
                System.out.println("\nInitializing PDE models");
            } else {
                System.out.println("\nTarget changed, recreating PDE models");
            }
        }
        PDEState oldState = this.fState;
        long startTime = System.currentTimeMillis();
        Map<String, LocalModelEntry> entries = Collections.synchronizedMap(new TreeMap());
        this.fCancelled = false;
        ITargetDefinition unresolvedRepoBasedtarget = null;
        try {
            unresolvedRepoBasedtarget = TargetPlatformHelper.getUnresolvedRepositoryBasedWorkspaceTarget();
        }
        catch (CoreException e) {
            PDECore.log(e);
        }
        if (unresolvedRepoBasedtarget != null && !P2TargetUtils.isProfileValid(unresolvedRepoBasedtarget)) {
            this.fState = new PDEState(new URL[0], true, true, (IProgressMonitor)subMon);
            this.fExternalManager.setModels(new IPluginModelBase[0]);
            this.fEntries = entries;
            LoadTargetDefinitionJob.load(unresolvedRepoBasedtarget);
            return;
        }
        long startTargetModels = System.currentTimeMillis();
        URL[] externalUrls = this.getExternalBundles((IProgressMonitor)subMon.split(40));
        if (subMon.isCanceled()) {
            if (PDECore.DEBUG_MODEL) {
                System.out.println("Target platform initialization cancelled by user");
            }
            PDECore.log((IStatus)new Status(2, "org.eclipse.pde.core", PDECoreMessages.PluginModelManager_TargetInitCancelledLog));
            this.fCancelled = true;
        }
        this.fState = new PDEState(externalUrls, true, true, (IProgressMonitor)subMon.split(15));
        this.fExternalManager.setModels(this.fState.getTargetModels());
        this.addToTable(entries, this.fExternalManager.getAllModels());
        boolean externalPluginsChanged = this.isSavedExternalPluginListDifferent(externalUrls);
        this.saveExternalPluginList(externalUrls);
        if (PDECore.DEBUG_MODEL) {
            System.out.println(String.valueOf(this.fState.getTargetModels().length) + " target models created in  " + (System.currentTimeMillis() - startTargetModels) + " ms");
        }
        IPluginModelBase[] models = this.fWorkspaceManager.getPluginModels();
        this.addToTable(entries, models);
        long startWorkspaceAdditions = System.currentTimeMillis();
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            this.addWorkspaceBundleToState(entries, model);
            ++n2;
        }
        subMon.split(15);
        if (PDECore.DEBUG_MODEL) {
            System.out.println(String.valueOf(this.fWorkspaceManager.getModels().length) + " workspace models created in  " + (System.currentTimeMillis() - startWorkspaceAdditions) + " ms");
        }
        this.fState.resolveState(true);
        subMon.split(5);
        this.fEntries = entries;
        PDECore.getDefault().getExtensionsRegistry().targetReloaded();
        if (oldState != null) {
            this.updateAffectedEntries(null, true);
        }
        if (externalPluginsChanged) {
            this.fireStateChanged(this.fState);
            if (PDECore.DEBUG_MODEL) {
                System.out.println("Loaded target models differ from saved list, PDE builder will run on all projects.");
            }
        }
        subMon.split(25);
        if (PDECore.DEBUG_MODEL) {
            long time = System.currentTimeMillis() - startTime;
            System.out.println("PDE plug-in model initialization complete: " + time + " ms");
        }
    }

    private URL[] getExternalBundles(IProgressMonitor monitor) {
        ITargetDefinition target = null;
        try {
            target = TargetPlatformHelper.getWorkspaceTargetResolved(monitor);
        }
        catch (CoreException e) {
            PDECore.log(e);
            return new URL[0];
        }
        if (target == null) {
            return new URL[0];
        }
        if (target.isResolved() && target.getStatus().getSeverity() == 4) {
            PDECore.log((IStatus)new Status(4, "org.eclipse.pde.core", PDECoreMessages.PluginModelManager_CurrentTargetPlatformContainsErrors, (Throwable)new CoreException(target.getStatus())));
            if (target.getStatus() instanceof MultiStatus) {
                MultiStatus multiStatus = (MultiStatus)target.getStatus();
                IStatus[] iStatusArray = multiStatus.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus childStatus = iStatusArray[n2];
                    PDECore.log(childStatus);
                    ++n2;
                }
            }
        }
        URL[] externalURLs = new URL[]{};
        TargetBundle[] bundles = target.getBundles();
        if (bundles != null) {
            ArrayList<URL> urls = new ArrayList<URL>(bundles.length);
            TargetBundle[] targetBundleArray = bundles;
            int n = bundles.length;
            int n3 = 0;
            while (n3 < n) {
                TargetBundle bundle = targetBundleArray[n3];
                if (bundle.getStatus().isOK()) {
                    try {
                        File file = URIUtil.toFile((URI)bundle.getBundleInfo().getLocation());
                        urls.add(file.toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                ++n3;
            }
            externalURLs = urls.toArray(new URL[urls.size()]);
        }
        return externalURLs;
    }

    private void addToTable(Map<String, LocalModelEntry> entries, IPluginModelBase[] models) {
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            String id = model.getPluginBase().getId();
            if (id != null) {
                LocalModelEntry entry = entries.get(id);
                if (entry == null) {
                    entry = new LocalModelEntry(id);
                    entries.put(id, entry);
                }
                entry.addModel(model);
            }
            ++n2;
        }
    }

    private synchronized void addWorkspaceBundleToState(IPluginModelBase model) {
        this.addWorkspaceBundleToState(this.fEntries, model);
    }

    private synchronized void addWorkspaceBundleToState(Map<String, LocalModelEntry> entries, IPluginModelBase model) {
        ModelEntry hostEntry;
        BundleDescription host;
        HostSpecification spec;
        String id = model.getPluginBase().getId();
        if (id == null) {
            return;
        }
        PDEPreferencesManager prefs = PDECore.getDefault().getPreferencesManager();
        boolean preferWorkspaceBundle = prefs.getBoolean("workspace_plugins_override_target");
        ModelEntry entry = entries.get(id);
        if (entry != null) {
            IPluginModelBase[] iPluginModelBaseArray = entry.getExternalModels();
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase externalModel = iPluginModelBaseArray[n2];
                if (preferWorkspaceBundle) {
                    this.fState.removeBundleDescription(externalModel.getBundleDescription());
                } else {
                    this.fState.updateBundleDescription(externalModel.getBundleDescription());
                }
                ++n2;
            }
        }
        this.fState.addBundle(model, false);
        BundleDescription desc = model.getBundleDescription();
        if (desc != null && (spec = desc.getHost()) != null && ("true".equals(System.getProperty("pde.allowCycles")) || this.isPatchFragment(entries, desc) || desc.getImportPackages().length > 0 || desc.getRequiredBundles().length > 0) && (host = (BundleDescription)spec.getSupplier()) != null && (hostEntry = (ModelEntry)entries.get(host.getName())) != null) {
            this.fState.addBundle(hostEntry.getModel(host), true);
        }
    }

    private boolean isPatchFragment(Map<String, LocalModelEntry> entries, BundleDescription desc) {
        ModelEntry entry = entries.get(desc.getSymbolicName());
        if (entry != null) {
            IPluginModelBase base = entry.getModel(desc);
            if (base == null) {
                return false;
            }
            return ClasspathUtilCore.isPatchFragment(base);
        }
        return false;
    }

    private void saveExternalPluginList(URL[] urls) {
        File dir = new File(PDECore.getDefault().getStateLocation().toOSString());
        File saveLocation = new File(dir, fExternalPluginListFile);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileWriter fileWriter = new FileWriter(saveLocation, false);){
                fileWriter.write("# List of external plug-in models previously loaded. Timestamp: " + System.currentTimeMillis() + "\n");
                URL[] uRLArray = urls;
                int n = urls.length;
                int n2 = 0;
                while (n2 < n) {
                    URL url = uRLArray[n2];
                    fileWriter.write(url.toString());
                    fileWriter.write("\n");
                    ++n2;
                }
                fileWriter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.log(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSavedExternalPluginListDifferent(URL[] newUrls) {
        HashSet<String> newExternal = new HashSet<String>();
        Object object = newUrls;
        int n = newUrls.length;
        int n2 = 0;
        while (n2 < n) {
            URL newUrl = object[n2];
            newExternal.add(newUrl.toString());
            ++n2;
        }
        File dir = new File(PDECore.getDefault().getStateLocation().toOSString());
        File saveLocation = new File(dir, fExternalPluginListFile);
        if (!saveLocation.exists()) {
            if (!newExternal.isEmpty()) return true;
            return false;
        }
        HashSet<String> previousExternal = new HashSet<String>();
        try {
            object = null;
            Object var7_11 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(saveLocation));){
                while (true) {
                    if (!reader.ready()) {
                        if (previousExternal.size() == newExternal.size()) break;
                        return true;
                    }
                    String url = reader.readLine();
                    if (url == null || url.trim().isEmpty() || url.startsWith("#")) continue;
                    previousExternal.add(url.trim());
                }
                Iterator iter = previousExternal.iterator();
                if (iter.hasNext()) {
                }
                if (newExternal.isEmpty()) return false;
                return true;
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
        }
        catch (IOException e) {
            PDECore.log(e);
        }
        return false;
    }

    private void handleAdd(String id, IPluginModelBase model, PluginModelDelta delta) {
        BundleDescription desc;
        LocalModelEntry entry = this.getEntryTable().get(id);
        if (entry == null) {
            entry = new LocalModelEntry(id);
            this.getEntryTable().put(id, entry);
            delta.addEntry(entry, 1);
        } else {
            delta.addEntry(entry, 4);
        }
        entry.addModel(model);
        if (model.getUnderlyingResource() != null) {
            this.addWorkspaceBundleToState(model);
        } else if (model.isEnabled() && !entry.hasWorkspaceModels() && (desc = model.getBundleDescription()).getContainingState().equals(this.fState.fState)) {
            this.fState.addBundleDescription(desc);
        }
    }

    private void handleRemove(String id, IPluginModelBase model, PluginModelDelta delta) {
        LocalModelEntry entry = this.getEntryTable().get(id);
        if (entry != null) {
            entry.removeModel(model);
            this.fState.removeBundleDescription(model.getBundleDescription());
            if (!entry.hasExternalModels() && !entry.hasWorkspaceModels()) {
                this.getEntryTable().remove(id);
                delta.addEntry(entry, 2);
                return;
            }
            if (model.getUnderlyingResource() != null && !entry.hasWorkspaceModels()) {
                IPluginModelBase[] external;
                IPluginModelBase[] iPluginModelBaseArray = external = entry.getExternalModels();
                int n = external.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginModelBase element = iPluginModelBaseArray[n2];
                    if (element.isEnabled()) {
                        this.fState.addBundleDescription(element.getBundleDescription());
                    }
                    ++n2;
                }
            }
            delta.addEntry(entry, 4);
        }
    }

    private void handleChange(IPluginModelBase model, PluginModelDelta delta) {
        BundleDescription desc = model.getBundleDescription();
        String oldID = desc == null ? null : desc.getSymbolicName();
        String newID = model.getPluginBase().getId();
        if (oldID == null && newID == null) {
            return;
        }
        if (oldID == null && newID != null) {
            this.handleAdd(newID, model, delta);
        } else if (oldID != null && newID == null) {
            this.handleRemove(oldID, model, delta);
            model.setBundleDescription(null);
        } else if (oldID != null && oldID.equals(newID)) {
            if (model.isEnabled()) {
                ModelEntry entry = this.getEntryTable().get(oldID);
                IPluginModelBase[] activeModels = entry.getActiveModels();
                boolean isActive = false;
                IPluginModelBase[] iPluginModelBaseArray = activeModels;
                int n = activeModels.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginModelBase activeModel = iPluginModelBaseArray[n2];
                    if (activeModel == model) {
                        isActive = true;
                        break;
                    }
                    ++n2;
                }
                if (isActive) {
                    IPluginModelBase[] models;
                    this.fEntries.remove(newID);
                    this.fState.removeBundleDescription(desc);
                    int i = 0;
                    while (i < this.fExternalManager.getAllModels().length) {
                        IPluginModelBase modelExternal = this.fExternalManager.getAllModels()[i];
                        if (modelExternal.getPluginBase().getId() != null && modelExternal.getPluginBase().getId().equals(newID)) {
                            this.addToTable(this.fEntries, new IPluginModelBase[]{modelExternal});
                        }
                        ++i;
                    }
                    IPluginModelBase[] iPluginModelBaseArray2 = models = this.fWorkspaceManager.getPluginModels();
                    int n3 = models.length;
                    n = 0;
                    while (n < n3) {
                        IPluginModelBase modelWorkspace = iPluginModelBaseArray2[n];
                        if (modelWorkspace.getPluginBase().getId() != null && modelWorkspace.getPluginBase().getId().equals(newID)) {
                            this.addToTable(this.fEntries, new IPluginModelBase[]{modelWorkspace});
                            this.addWorkspaceBundleToState(this.fEntries, modelWorkspace);
                        }
                        ++n;
                    }
                }
            } else {
                this.fState.removeBundleDescription(model.getBundleDescription());
            }
            delta.addEntry(this.findEntry(oldID), 4);
        } else {
            this.handleRemove(oldID, model, delta);
            this.handleAdd(newID, model, delta);
        }
    }

    public ModelEntry findEntry(String id) {
        if ("system.bundle".equals(id)) {
            id = this.getSystemBundleId();
        }
        return id == null ? null : (ModelEntry)this.getEntryTable().get(id);
    }

    public IPluginModelBase findModel(String id) {
        ModelEntry entry = this.findEntry(id);
        return entry == null ? null : entry.getModel();
    }

    public IPluginModelBase findModel(IProject project) {
        this.initializeTable(null);
        return this.fWorkspaceManager.getPluginModel(project);
    }

    public IPluginModelBase findModel(BundleDescription desc) {
        ModelEntry entry = desc != null ? this.findEntry(desc.getSymbolicName()) : null;
        return entry == null ? null : entry.getModel(desc);
    }

    public IPluginModelBase[] getActiveModels() {
        return this.getActiveModels(true);
    }

    public IPluginModelBase[] getActiveModels(boolean includeFragments) {
        int size = this.getEntryTable().size();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>(size);
        for (ModelEntry modelEntry : this.getEntryTable().values()) {
            IPluginModelBase[] models;
            IPluginModelBase[] iPluginModelBaseArray = models = modelEntry.getActiveModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                if (model instanceof IPluginModel || includeFragments) {
                    result.add(model);
                }
                ++n2;
            }
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModelBase[] getAllModels() {
        return this.getAllModels(true);
    }

    public IPluginModelBase[] getAllModels(boolean includeFragments) {
        int size = this.getEntryTable().size();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>(size);
        for (ModelEntry modelEntry : this.getEntryTable().values()) {
            IPluginModelBase[] models;
            IPluginModelBase[] iPluginModelBaseArray = models = modelEntry.hasWorkspaceModels() ? modelEntry.getWorkspaceModels() : modelEntry.getExternalModels();
            int n = models.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n2];
                if (model instanceof IPluginModel || includeFragments) {
                    result.add(model);
                }
                ++n2;
            }
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    public IPluginModelBase[] getExternalModels() {
        this.initializeTable(null);
        return this.fExternalManager.getAllModels();
    }

    public IPluginModelBase[] getWorkspaceModels() {
        this.initializeTable(null);
        return this.fWorkspaceManager.getPluginModels();
    }

    public ExternalModelManager getExternalModelManager() {
        this.initializeTable(null);
        return this.fExternalManager;
    }

    public PDEState getState() {
        this.initializeTable(null);
        return this.fState;
    }

    public String getSystemBundleId() {
        return this.getState().getSystemBundle();
    }

    protected void shutdown() {
        this.fWorkspaceManager.shutdown();
        this.fExternalManager.shutdown();
        if (this.fListeners != null) {
            this.fListeners.clear();
        }
        if (this.fStateListeners != null) {
            this.fStateListeners.clear();
        }
    }

    public void addExtensionDeltaListener(IExtensionDeltaListener listener) {
        this.fWorkspaceManager.addExtensionDeltaListener(listener);
    }

    public void removeExtensionDeltaListener(IExtensionDeltaListener listener) {
        this.fWorkspaceManager.removeExtensionDeltaListener(listener);
    }

    public void bundleRootChanged(IProject project) {
        this.fWorkspaceManager.initialize();
        this.fWorkspaceManager.removeModel(project);
        if (this.fWorkspaceManager.isInterestingProject(project)) {
            this.fWorkspaceManager.createModel(project, false);
            Object model = this.fWorkspaceManager.getModel(project);
            this.fWorkspaceManager.addChange(model, 4);
        }
        this.fWorkspaceManager.processModelChanges();
    }

    private class LocalModelEntry
    extends ModelEntry {
        public LocalModelEntry(String id) {
            super(id);
        }

        public void addModel(IPluginModelBase model) {
            if (model.getUnderlyingResource() != null) {
                this.fWorkspaceEntries.add(model);
            } else {
                this.fExternalEntries.add(model);
            }
        }

        public void removeModel(IPluginModelBase model) {
            if (model.getUnderlyingResource() != null) {
                this.fWorkspaceEntries.remove(model);
            } else {
                this.fExternalEntries.remove(model);
            }
        }
    }

    class UpdateClasspathsJob
    extends Job {
        private List<IJavaProject> fProjects;
        private List<IClasspathContainer> fContainers;

        public UpdateClasspathsJob() {
            super(PDECoreMessages.PluginModelManager_1);
            this.fProjects = new ArrayList<IJavaProject>();
            this.fContainers = new ArrayList<IClasspathContainer>();
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                boolean more = false;
                do {
                    IJavaProject[] projects = null;
                    IClasspathContainer[] containers = null;
                    List<IJavaProject> list = this.fProjects;
                    synchronized (list) {
                        projects = this.fProjects.toArray(new IJavaProject[this.fProjects.size()]);
                        containers = this.fContainers.toArray(new IClasspathContainer[this.fContainers.size()]);
                        this.fProjects.clear();
                        this.fContainers.clear();
                    }
                    JavaCore.setClasspathContainer((IPath)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH, (IJavaProject[])projects, (IClasspathContainer[])containers, (IProgressMonitor)monitor);
                    list = this.fProjects;
                    synchronized (list) {
                        more = !this.fProjects.isEmpty();
                    }
                } while (more);
            }
            catch (JavaModelException e) {
                return e.getStatus();
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(IJavaProject[] projects, IClasspathContainer[] containers) {
            List<IJavaProject> list = this.fProjects;
            synchronized (list) {
                int i = 0;
                while (i < containers.length) {
                    this.fProjects.add(projects[i]);
                    this.fContainers.add(containers[i]);
                    ++i;
                }
            }
        }
    }
}

