/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.IEditableModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.AbstractFeatureModel;
import org.eclipse.pde.internal.core.feature.Feature;

public class WorkspaceFeatureModel
extends AbstractFeatureModel
implements IEditableModel {
    private static final long serialVersionUID = 1L;
    private boolean dirty;
    private IFile file;
    private boolean editable = true;

    public WorkspaceFeatureModel() {
    }

    public WorkspaceFeatureModel(IFile file) {
        this.setFile(file);
    }

    @Override
    public void fireModelChanged(IModelChangedEvent event) {
        this.setDirty(event.getChangeType() != 99);
        super.fireModelChanged(event);
    }

    @Override
    protected NLResourceHelper createNLResourceHelper() {
        block4: {
            try {
                if (this.file != null && this.file.getLocation() != null) break block4;
                return null;
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        IPath path = this.file.getLocation().removeLastSegments(1);
        String installLocation = path.toOSString();
        if (!installLocation.startsWith("file:")) {
            installLocation = "file:" + installLocation;
        }
        URL url = new URL(String.valueOf(installLocation) + "/");
        String name = "feature";
        NLResourceHelper helper = new NLResourceHelper(name, new URL[]{url});
        return helper;
    }

    /*
     * Loose catch block
     */
    public String getContents() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                String string;
                PrintWriter writer;
                StringWriter swriter;
                block18: {
                    swriter = new StringWriter();
                    writer = new PrintWriter(swriter);
                    this.setLoaded(true);
                    this.save(writer);
                    writer.flush();
                    string = swriter.toString();
                    if (writer != null) {
                        writer.close();
                    }
                    if (swriter == null) break block18;
                    swriter.close();
                }
                return string;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (swriter != null) {
                                swriter.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            PDECore.logException(e);
            return "";
        }
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    public String getInstallLocation() {
        IPath path = this.file.getParent().getLocation();
        return path == null ? null : path.toOSString();
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.file;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public boolean isInSync() {
        return this.isInSync(this.file.getLocation().toFile());
    }

    @Override
    protected void updateTimeStamp() {
        this.updateTimeStamp(this.file.getLocation().toFile());
    }

    @Override
    public void load() {
        if (this.file == null) {
            return;
        }
        if (this.file.exists()) {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (BufferedInputStream stream = new BufferedInputStream(this.file.getContents(true));){
                    if (((InputStream)stream).available() > 0) {
                        this.load(stream, false);
                    } else {
                        this.setLoaded(true);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (CoreException e) {
                PDECore.logException(e);
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        } else {
            this.feature = new Feature();
            this.feature.model = this;
            this.setLoaded(true);
        }
    }

    @Override
    public void save() {
        if (this.file == null) {
            return;
        }
        String contents = WorkspaceFeatureModel.fixLineDelimiter(this.getContents(), this.file);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));){
                if (this.file.exists()) {
                    this.file.setContents((InputStream)stream, false, false, null);
                } else {
                    this.file.create((InputStream)stream, false, null);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            PDECore.logException(e);
        }
    }

    @Override
    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.feature.write("", writer);
        }
        this.setDirty(false);
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    public void setFile(IFile newFile) {
        this.file = newFile;
    }
}

