/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.BaseBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ConfigurationAreaBlock
extends BaseBlock {
    private Button fUseDefaultLocationButton;
    private Button fClearConfig;
    private String fLastEnteredConfigArea;
    private String fLastKnownConfigName;
    private static String DEFAULT_DIR = "${workspace_loc}/.metadata/.plugins/org.eclipse.pde.core/";

    public ConfigurationAreaBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.ConfigurationTab_configAreaGroup);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(768));
        this.fUseDefaultLocationButton = new Button((Composite)group, 32);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fUseDefaultLocationButton.setLayoutData((Object)gd);
        this.fUseDefaultLocationButton.setText(PDEUIMessages.ConfigurationTab_useDefaultLoc);
        this.fUseDefaultLocationButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean useDefaultArea = this.fUseDefaultLocationButton.getSelection();
            if (useDefaultArea) {
                this.fLocationText.setText(String.valueOf(DEFAULT_DIR) + this.fLastKnownConfigName);
            } else {
                this.fLocationText.setText(this.fLastEnteredConfigArea);
            }
            this.enableBrowseSection(!useDefaultArea);
            this.fLocationText.setEditable(!useDefaultArea);
            if (useDefaultArea) {
                this.fLocationText.setEnabled(true);
            }
        }));
        this.createText((Composite)group, PDEUIMessages.ConfigurationTab_configLog, 20);
        this.fLocationText.addModifyListener(e -> {
            if (!this.fUseDefaultLocationButton.getSelection()) {
                this.fLastEnteredConfigArea = this.getLocation();
            }
        });
        Composite buttons = new Composite((Composite)group, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        this.fClearConfig = new Button(buttons, 32);
        this.fClearConfig.setText(PDEUIMessages.ConfigurationTab_clearArea);
        this.fClearConfig.setLayoutData((Object)new GridData(768));
        this.fClearConfig.addSelectionListener((SelectionListener)this.fListener);
        this.createButtons(buttons, new String[]{PDEUIMessages.BaseBlock_workspace, PDEUIMessages.BaseBlock_filesystem, PDEUIMessages.BaseBlock_variables});
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        this.fLastKnownConfigName = configuration.getName();
        boolean useDefaultArea = configuration.getAttribute("useDefaultConfigArea", true);
        this.fUseDefaultLocationButton.setSelection(useDefaultArea);
        this.enableBrowseSection(!useDefaultArea);
        this.fLocationText.setEditable(!useDefaultArea);
        if (useDefaultArea) {
            this.fLocationText.setEnabled(true);
        }
        this.fClearConfig.setSelection(configuration.getAttribute("clearConfig", false));
        this.fLastEnteredConfigArea = useDefaultArea ? String.valueOf(DEFAULT_DIR) + this.fLastKnownConfigName : configuration.getAttribute("configLocation", String.valueOf(DEFAULT_DIR) + this.fLastKnownConfigName);
        this.fLocationText.setText(this.fLastEnteredConfigArea);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("useDefaultConfigArea", this.fUseDefaultLocationButton.getSelection());
        if (this.fUseDefaultLocationButton.getSelection() && !this.fLastKnownConfigName.equals(configuration.getName())) {
            this.fLocationText.setText(String.valueOf(DEFAULT_DIR) + configuration.getName());
        }
        configuration.setAttribute("configLocation", this.getLocation());
        configuration.setAttribute("clearConfig", this.fClearConfig.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration, boolean isJUnit) {
        configuration.setAttribute("clearConfig", isJUnit);
        boolean useDefaultArea = !isJUnit || LaunchArgumentsHelper.getDefaultJUnitWorkspaceIsContainer();
        configuration.setAttribute("useDefaultConfigArea", useDefaultArea);
        String location = isJUnit && !useDefaultArea ? LaunchArgumentsHelper.getDefaultJUnitConfigurationLocation() : String.valueOf(DEFAULT_DIR) + configuration.getName();
        configuration.setAttribute("configLocation", location);
    }

    @Override
    protected String getName() {
        return PDEUIMessages.ConfigurationAreaBlock_name;
    }

    @Override
    protected boolean isFile() {
        return false;
    }

    @Override
    public String validate() {
        if (this.fUseDefaultLocationButton.getSelection()) {
            return null;
        }
        return super.validate();
    }
}

