/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.P2TargetUtils;

public class IUContentProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        IUBundleContainer location = (IUBundleContainer)parentElement;
        if (location.isResolved()) {
            try {
                ITargetDefinition target = location.getTarget();
                if (target == null || !P2TargetUtils.isResolved((ITargetDefinition)target)) {
                    return new Object[0];
                }
                IInstallableUnit[] units = location.getInstallableUnits();
                ArrayList<IUWrapper> wrappedUnits = new ArrayList<IUWrapper>(units.length);
                IInstallableUnit[] iInstallableUnitArray = units;
                int n = units.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstallableUnit unit = iInstallableUnitArray[n2];
                    wrappedUnits.add(new IUWrapper(unit, location));
                    ++n2;
                }
                return wrappedUnits.toArray();
            }
            catch (CoreException e) {
                return new Object[]{e.getStatus()};
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IUWrapper) {
            return ((IUWrapper)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public class IUWrapper {
        private IInstallableUnit fIU;
        private IUBundleContainer fParent;

        public IUWrapper(IInstallableUnit unit, IUBundleContainer parent) {
            this.fIU = unit;
            this.fParent = parent;
        }

        public IInstallableUnit getIU() {
            return this.fIU;
        }

        public IUBundleContainer getParent() {
            return this.fParent;
        }
    }
}

