/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.preservation;

import org.eclipse.photran.internal.core.util.TwoKeyHashMap;
import org.eclipse.photran.internal.core.vpg.VPGEdge;

public class PreservationRuleset {
    private TwoKeyHashMap<Integer, VPGEdge.Classification, Rule> preservationRules = new TwoKeyHashMap();

    public void preserveAll(int edgeType) {
        VPGEdge.Classification[] classificationArray = VPGEdge.Classification.values();
        int n = classificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            VPGEdge.Classification c = classificationArray[n2];
            this.addRule(edgeType, c, Rule.PRESERVE_ALL);
            ++n2;
        }
    }

    public void preserveIncoming(int edgeType) {
        this.addRule(edgeType, VPGEdge.Classification.INCOMING, Rule.PRESERVE_ALL);
        this.addRule(edgeType, VPGEdge.Classification.EXTERNAL, Rule.PRESERVE_ALL);
    }

    public void preserveSupersetOutgoing(int edgeType) {
        this.addRule(edgeType, VPGEdge.Classification.OUTGOING, Rule.PRESERVE_SUPERSET);
        this.addRule(edgeType, VPGEdge.Classification.EXTERNAL, Rule.PRESERVE_ALL);
    }

    public void preserveSubsetInternal(int edgeType) {
        this.addRule(edgeType, VPGEdge.Classification.INTERNAL, Rule.PRESERVE_SUBSET);
        this.addRule(edgeType, VPGEdge.Classification.EXTERNAL, Rule.PRESERVE_ALL);
    }

    private void addRule(int edgeType, VPGEdge.Classification classification, Rule rule) {
        this.preservationRules.put(edgeType, classification, rule);
    }

    void invokeCallback(int edgeType, VPGEdge.Classification classification, Processor processor) {
        this.getRule(edgeType, classification).processUsing(processor);
    }

    private Rule getRule(int edgeType, VPGEdge.Classification classification) {
        Rule result = this.preservationRules.getEntry(edgeType, classification);
        if (result != null) {
            return result;
        }
        return Rule.IGNORE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int type : this.preservationRules.keySet()) {
            sb.append("Type ");
            sb.append(type);
            sb.append(": ");
            VPGEdge.Classification[] classificationArray = VPGEdge.Classification.values();
            int n = classificationArray.length;
            int n2 = 0;
            while (n2 < n) {
                VPGEdge.Classification c = classificationArray[n2];
                sb.append("  ");
                sb.append(c.toString());
                sb.append(" - ");
                sb.append((Object)this.getRule(type, c));
                ++n2;
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    static abstract class Processor {
        Processor() {
        }

        abstract void handlePreserveAll();

        abstract void handlePreserveSubset();

        abstract void handlePreserveSuperset();

        abstract void handleIgnore();
    }

    private static enum Rule {
        PRESERVE_ALL{

            @Override
            protected void processUsing(Processor p) {
                p.handlePreserveAll();
            }
        }
        ,
        PRESERVE_SUBSET{

            @Override
            protected void processUsing(Processor p) {
                p.handlePreserveSubset();
            }
        }
        ,
        PRESERVE_SUPERSET{

            @Override
            protected void processUsing(Processor p) {
                p.handlePreserveSuperset();
            }
        }
        ,
        IGNORE{

            @Override
            protected void processUsing(Processor p) {
                p.handleIgnore();
            }
        };


        protected abstract void processUsing(Processor var1);
    }
}

