/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.actions;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.FortranAST;
import org.eclipse.photran.internal.core.SyntaxException;
import org.eclipse.photran.internal.core.lexer.ASTLexerFactory;
import org.eclipse.photran.internal.core.lexer.IAccumulatingLexer;
import org.eclipse.photran.internal.core.lexer.LexerException;
import org.eclipse.photran.internal.core.lexer.TokenList;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.Parser;
import org.eclipse.photran.internal.core.refactoring.infrastructure.SourcePrinter;
import org.eclipse.photran.internal.core.reindenter.Reindenter;
import org.eclipse.photran.internal.core.sourceform.SourceForm;
import org.eclipse.photran.internal.ui.actions.FortranEditorASTActionDelegate;
import org.eclipse.photran.internal.ui.actions.Messages;
import org.eclipse.swt.widgets.Shell;

public class CorrectIndentationAction
extends FortranEditorASTActionDelegate {
    public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
        try {
            if (this.ensureNotFixedForm()) {
                ITextSelection selectedRegion = this.getFortranEditor().getSelection();
                String sourceCode = this.reindent(selectedRegion);
                this.setTextInEditor(sourceCode);
                this.setEditorSelectionTo(selectedRegion, sourceCode);
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.getClass().getName();
            }
            MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)message);
        }
    }

    private boolean ensureNotFixedForm() {
        IFile ifile = this.getFortranEditor().getIFile();
        if (ifile != null && SourceForm.of((IFile)ifile).isFixedForm()) {
            MessageDialog.openError((Shell)this.getFortranEditor().getShell(), (String)"Error", (String)Messages.CorrectIndentationAction_NotAvailableForFixedForm);
            return false;
        }
        return true;
    }

    private String reindent(ITextSelection selection) throws IOException, LexerException, SyntaxException {
        IFortranAST ast = this.parseTextInEditor();
        if (selection.getLength() == 0) {
            Reindenter.reindent((IASTNode)ast.getRoot(), (IFortranAST)ast, (Reindenter.Strategy)Reindenter.Strategy.REINDENT_EACH_LINE);
        } else {
            Reindenter.reindent((int)(selection.getStartLine() + 1), (int)(selection.getEndLine() + 1), (IFortranAST)ast, (Reindenter.Strategy)Reindenter.Strategy.REINDENT_EACH_LINE);
        }
        return SourcePrinter.getSourceCodeFromAST((IFortranAST)ast);
    }

    private IFortranAST parseTextInEditor() throws IOException, LexerException, SyntaxException {
        IFile ifile = this.getFortranEditor().getIFile();
        String filename = ifile != null ? ifile.getName() : "new_file.f90";
        IAccumulatingLexer lexer = new ASTLexerFactory().createLexer((Reader)new StringReader(this.getDocument().get()), ifile, filename, SourceForm.of((IFile)ifile));
        ASTExecutableProgramNode astRoot = new Parser().parse(lexer);
        return new FortranAST(ifile, astRoot, new TokenList(astRoot));
    }

    private IDocument getDocument() {
        return this.getFortranEditor().getDocumentProvider().getDocument((Object)this.getFortranEditor().getEditorInput());
    }

    private void setTextInEditor(String sourceCode) {
        this.getDocument().set(sourceCode);
    }

    private void setEditorSelectionTo(ITextSelection selection, String sourceCode) {
        int newOffset = Math.min(selection.getOffset(), sourceCode.length() - 1);
        this.getFortranEditor().selectAndReveal(newOffset, 0);
    }
}

