/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.browser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.photran.internal.core.util.Pair;
import org.eclipse.photran.internal.core.vpg.IVPGNode;
import org.eclipse.photran.internal.core.vpg.eclipse.EclipseVPG;
import org.eclipse.photran.internal.ui.browser.Messages;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

class AnnotationsTab {
    private EclipseVPG vpg;
    private TabItem annotations;
    private SashForm annotationsSash;
    private StyledText styledText;
    private TabFolder annotationsTabFolder;
    private Composite composite;
    private Label label;
    private String filename;
    private List<Pair<? extends IVPGNode, Integer>> annotationsInFile;
    private Set<Pair<? extends IVPGNode, Integer>> annotationsToShow;
    private HashMap<Integer, TabItem> hashMap;

    public AnnotationsTab(TabItem annotations, TabFolder tabFolder, EclipseVPG vpg) {
        this.annotations = annotations;
        this.annotationsInFile = Collections.emptyList();
        this.annotationsToShow = Collections.emptySet();
        this.vpg = vpg;
        this.hashMap = new HashMap();
        this.createControls(tabFolder);
    }

    private void createControls(TabFolder tabFolder) {
        this.createHorizontalSash(tabFolder);
        this.createStyledText();
        this.createComposite();
        this.createAnnotationsTabFolder();
        this.createLabel();
    }

    private void createComposite() {
        this.composite = new Composite((Composite)this.annotationsSash, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.composite.setLayout((Layout)layout);
    }

    private void createAnnotationsTabFolder() {
        this.annotationsTabFolder = new TabFolder(this.composite, 4);
        this.annotationsTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createLabel() {
        this.label = new Label(this.composite, 0);
        this.label.setText("");
        this.label.setLayoutData((Object)new GridData(16384, 128, false, false));
    }

    private void createNewTab(int annotationType, String description) {
        if (!this.hashMap.containsKey(annotationType)) {
            TabItem tabItem = new TabItem(this.annotationsTabFolder, 0);
            tabItem.setText(description);
            this.hashMap.put(annotationType, tabItem);
        }
    }

    private void createHorizontalSash(TabFolder tabFolder) {
        this.annotationsSash = new SashForm((Composite)tabFolder, 512);
        this.annotationsSash.setLayout((Layout)new FillLayout());
        this.annotationsSash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.annotations.setControl((Control)this.annotationsSash);
    }

    private void createStyledText() {
        this.styledText = new StyledText((Composite)this.annotationsSash, 778);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.verticalSpan = 1;
        this.styledText.setLayoutData((Object)gridData);
        this.styledText.setFont(JFaceResources.getTextFont());
        this.styledText.addPaintListener((PaintListener)new RectanglePainter(this.styledText));
        this.styledText.addCaretListener((CaretListener)new ShowEdgeCaretListener());
    }

    public void showAnnotations(String filename) {
        this.filename = filename;
        Object ast = this.vpg.acquireTransientAST(filename);
        if (ast == null) {
            this.styledText.setText(Messages.bind((String)Messages.AnnotationsTab_UnableToParse, (Object)filename));
        } else {
            this.styledText.setText(this.vpg.getSourceCodeFromAST(ast));
        }
        this.annotationsInFile = new ArrayList<Pair<? extends IVPGNode, Integer>>();
        for (Pair pair : this.vpg.getAllAnnotationsFor(filename)) {
            this.annotationsInFile.add((Pair<? extends IVPGNode, Integer>)pair);
        }
        for (Pair pair : this.annotationsInFile) {
            this.createNewTab((Integer)pair.snd, this.vpg.describeAnnotationType(((Integer)pair.snd).intValue()));
        }
    }

    private Rectangle drawRectangle(PaintEvent e, int startOffset, int endOffset) {
        if (this.isValid(startOffset) && this.isValid(endOffset)) {
            Rectangle srcRect = this.styledText.getTextBounds(startOffset, Math.max(startOffset, Math.max(0, endOffset - 1)));
            e.gc.drawRectangle(srcRect);
            return srcRect;
        }
        return null;
    }

    private boolean isValid(int offset) {
        return offset >= 0 && offset < this.styledText.getCharCount();
    }

    private final class RectanglePainter
    implements PaintListener {
        private final StyledText styledText;

        private RectanglePainter(StyledText styledText) {
            this.styledText = styledText;
        }

        public void paintControl(PaintEvent e) {
            for (Pair pair : AnnotationsTab.this.annotationsInFile) {
                IVPGNode tokenRef = (IVPGNode)pair.fst;
                if (!tokenRef.getFilename().equals(AnnotationsTab.this.filename)) continue;
                AnnotationsTab.this.drawRectangle(e, tokenRef.getOffset(), tokenRef.getEndOffset());
            }
        }
    }

    private final class ShowEdgeCaretListener
    implements CaretListener {
        private ShowEdgeCaretListener() {
        }

        private Set<Pair<? extends IVPGNode, Integer>> collectSelectedAnnotations(int caretOffset) {
            HashSet<Pair<? extends IVPGNode, Integer>> AnnotationsToShow = new HashSet<Pair<? extends IVPGNode, Integer>>();
            for (Pair pair : AnnotationsTab.this.annotationsInFile) {
                IVPGNode tokenRef = (IVPGNode)pair.fst;
                if (tokenRef.getOffset() > caretOffset || tokenRef.getEndOffset() < caretOffset) continue;
                AnnotationsToShow.add((Pair<? extends IVPGNode, Integer>)pair);
            }
            return AnnotationsToShow;
        }

        public void caretMoved(CaretEvent event) {
            AnnotationsTab.this.annotationsToShow = this.collectSelectedAnnotations(event.caretOffset);
            this.displayAnnotations();
            this.displayCaretInformation(event);
            AnnotationsTab.this.styledText.redraw();
        }

        private void displayAnnotations() {
            Text blankText = new Text((Composite)AnnotationsTab.this.annotationsTabFolder, 778);
            blankText.setText(Messages.AnnotationsTab_NoAnnotationsToShow);
            Iterator<Object> iterator = AnnotationsTab.this.hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                int type = (Integer)iterator.next();
                ((TabItem)AnnotationsTab.this.hashMap.get(type)).setControl((Control)blankText);
            }
            for (Pair pair : AnnotationsTab.this.annotationsToShow) {
                IVPGNode tokenRef = (IVPGNode)pair.fst;
                int annotationType = (Integer)pair.snd;
                Text textField = new Text((Composite)AnnotationsTab.this.annotationsTabFolder, 778);
                textField.setLayoutData((Object)new GridData(4, 4, true, true));
                String text = tokenRef.getAnnotation(annotationType).toString();
                textField.setText(text);
                ((TabItem)AnnotationsTab.this.hashMap.get(annotationType)).setControl((Control)textField);
            }
        }

        private void displayCaretInformation(CaretEvent event) {
            int caretLine = AnnotationsTab.this.styledText.getLineAtOffset(AnnotationsTab.this.styledText.getCaretOffset());
            int lineOffset = AnnotationsTab.this.styledText.getOffsetAtLine(caretLine);
            int caretOffset = AnnotationsTab.this.styledText.getCaretOffset();
            int caretColumn = caretOffset - lineOffset + 1;
            AnnotationsTab.this.label.setText(Messages.bind((String)Messages.AnnotationsTab_LineColOffset, (Object[])new Object[]{caretLine + 1, caretColumn, AnnotationsTab.this.styledText.getCaretOffset()}));
            AnnotationsTab.this.label.pack();
        }
    }
}

