/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.model;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rcptt.core.ecl.model.ArgDecl;
import org.eclipse.rcptt.core.ecl.model.Declaration;
import org.eclipse.rcptt.core.ecl.model.SrcLoc;
import org.eclipse.rcptt.ecl.doc.EclDocWriter;
import org.eclipse.rcptt.util.StringUtils;

public class ProcDecl
extends Declaration {
    private Map<String, ArgDecl> args = new LinkedHashMap<String, ArgDecl>();
    private String description;

    public ProcDecl(String name, SrcLoc location) {
        super(name, location);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ArgDecl[] getArgs() {
        return this.args.values().toArray(new ArgDecl[this.args.size()]);
    }

    public void addArg(ArgDecl param) {
        param.parent = this;
        param.container = this.container;
        this.args.put(param.name, param);
    }

    public int argCount() {
        return this.args.size();
    }

    public ArgDecl resolveArg(String name) {
        return this.args.get(name);
    }

    public String toString() {
        return String.format("Procedure name: %s, params: %s", this.name, StringUtils.join((char)',', this.args.keySet()));
    }

    private ArgDecl getInputArg() {
        for (ArgDecl arg : this.args.values()) {
            if (!arg.isInput) continue;
            return arg;
        }
        return null;
    }

    @Override
    public String doc() {
        StringWriter sw = new StringWriter();
        EclDocWriter dw = new EclDocWriter((Writer)sw);
        try {
            String path;
            dw.text(String.format("Procedure <b>%s</b>", this.name));
            if (this.description != null && !this.description.isEmpty()) {
                dw.text("<br />" + this.description);
            }
            ArgDecl input = this.getInputArg();
            dw.dl();
            if (input != null) {
                dw.dt("Input:");
                dw.dd();
                this.writeArg(input, dw);
                dw.close();
            }
            if (this.args.size() > (input == null ? 0 : 1)) {
                dw.dt("Arguments:");
                for (ArgDecl arg : this.args.values()) {
                    if (arg == input) continue;
                    dw.dd();
                    this.writeArg(arg, dw);
                    dw.close();
                }
            }
            if ((path = ProcDecl.getResourcePath(this.container.getResource())) != null) {
                dw.dt("Defined in:");
                dw.dd(path);
            }
            dw.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return sw.toString();
    }

    private void writeArg(ArgDecl arg, EclDocWriter writer) throws IOException {
        writer.b(arg.name);
        if (arg.hasDefaultValue) {
            writer.raw(" optional");
        }
        if (arg.simpleValue != null) {
            writer.raw(" = ");
            writer.raw(ProcDecl.defaultValueForDoc(arg.simpleValue));
        }
    }
}

