/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.parser.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rcptt.core.ecl.parser.ast.Command;
import org.eclipse.rcptt.core.ecl.parser.ast.Node;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;

public class NodePath {
    public final int offset;
    public final Script script;
    public List<Node> nodes;

    public NodePath(List<Node> nodes, Script script, int offset) {
        this.nodes = nodes;
        this.offset = offset;
        this.script = script;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public List<Command> findCommands(String ... names) {
        ArrayList<Command> result = new ArrayList<Command>();
        List<String> namesList = Arrays.asList(names);
        for (Node node : this.nodes) {
            if (!(node instanceof Command)) continue;
            Command cmd = (Command)node;
            if (!namesList.contains(cmd.name.text)) continue;
            result.add(cmd);
        }
        return result;
    }

    public Command lastCommand(String name) {
        List<Command> commands = this.findCommands(name);
        if (commands.isEmpty()) {
            return null;
        }
        return commands.get(commands.size() - 1);
    }

    public <T> boolean endsWith(Class<T> clazz) {
        return !this.isEmpty() && clazz.isAssignableFrom(this.lastNode().getClass());
    }

    public <T> T lastOf(Class<T> clazz) {
        int i = this.nodes.size() - 1;
        while (i >= 0) {
            Node node = this.nodes.get(i);
            if (clazz.isAssignableFrom(node.getClass())) {
                return clazz.cast(node);
            }
            --i;
        }
        return null;
    }

    public <T> T firstOf(Class<T> clazz) {
        for (Node node : this.nodes) {
            if (!clazz.isAssignableFrom(node.getClass())) continue;
            return clazz.cast(node);
        }
        return null;
    }

    public boolean endsWith(Class<?> ... classes) {
        if (classes.length > this.nodes.size()) {
            return false;
        }
        int delta = this.nodes.size() - classes.length;
        int i = 0;
        while (i < classes.length) {
            if (!classes[i].isAssignableFrom(this.nodes.get(i + delta).getClass())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Node lastNode() {
        return this.nodes.isEmpty() ? null : this.nodes.get(this.nodes.size() - 1);
    }

    public Node fromEnd(int i) {
        int index = this.nodes.size() - 1 - i;
        if (index < 0 || index >= this.nodes.size()) {
            return null;
        }
        return this.nodes.get(index);
    }
}

