/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testrail.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.testrail.TestRailService;
import org.eclipse.rcptt.testrail.domain.TestRailTestCase;
import org.eclipse.rcptt.ui.controls.SuggestionItem;
import org.eclipse.rcptt.ui.editors.IScenarioPropertyProvider;

public class TestRailPropertySuggestionProvider
implements IScenarioPropertyProvider {
    private static final long UPDATE_DELAY = 5000L;
    private List<SuggestionItem> testCaseIdSuggestions;

    public List<SuggestionItem> getProperties(Scenario scenario) {
        ArrayList<SuggestionItem> props = new ArrayList<SuggestionItem>();
        props.add(new SuggestionItem("testrail-id"));
        return props;
    }

    public List<SuggestionItem> getPropertyValues(String name) {
        switch (name) {
            case "testrail-id": {
                this.initializeSuggestions();
                return this.testCaseIdSuggestions;
            }
        }
        return Collections.emptyList();
    }

    private void initializeSuggestions() {
        if (this.testCaseIdSuggestions == null) {
            this.testCaseIdSuggestions = this.getTestCaseIdSuggestions();
            this.scheduleSuggestionsUpdate();
        }
    }

    private void scheduleSuggestionsUpdate() {
        Job openJob = new Job("Connecting to the TestRail Host"){

            protected IStatus run(IProgressMonitor monitor) {
                TestRailPropertySuggestionProvider.this.testCaseIdSuggestions = TestRailPropertySuggestionProvider.this.getTestCaseIdSuggestions();
                this.schedule(5000L);
                return Status.OK_STATUS;
            }
        };
        openJob.schedule(5000L);
    }

    private List<SuggestionItem> getTestCaseIdSuggestions() {
        TestRailService service = new TestRailService();
        List testCases = service.getTestCases(true);
        if (testCases == null) {
            return Collections.emptyList();
        }
        this.testCaseIdSuggestions = testCases.stream().map(testCase -> this.getTestCaseIdSuggestion((TestRailTestCase)testCase)).collect(Collectors.toList());
        return this.testCaseIdSuggestions;
    }

    private SuggestionItem getTestCaseIdSuggestion(TestRailTestCase testCase) {
        String value = "C" + testCase.getId();
        String textDescription = testCase.getTextDescription();
        String htmlDescription = testCase.getHTMLDescription();
        SuggestionItem.SuggestionDescription description = new SuggestionItem.SuggestionDescription(textDescription, htmlDescription);
        return new SuggestionItem(value, description);
    }
}

