/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathEvaluator {
    private Document doc;
    private Map<String, String> namespaces;

    public XPathEvaluator(InputStream inputStream, boolean namespaceAware) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaceAware);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.doc = builder.parse(new InputSource(inputStream));
        inputStream.close();
        this.namespaces = new HashMap<String, String>();
    }

    public void setNamespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
    }

    public String evaluateXPath(String xPathExpression) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new UniversalNamespaceResolver(this.doc, this.namespaces));
        return xPath.compile(xPathExpression).evaluate(this.doc);
    }

    public void printDocument(Result target) throws IOException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(this.doc), target);
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.printDocument(new StreamResult(writer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    private class UniversalNamespaceResolver
    implements NamespaceContext {
        private Document sourceDocument;
        private Map<String, String> userDefinedNamespaces;

        public UniversalNamespaceResolver(Document document, Map<String, String> namespaces) {
            this.sourceDocument = document;
            this.userDefinedNamespaces = namespaces;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("")) {
                return this.sourceDocument.lookupNamespaceURI(null);
            }
            if (this.userDefinedNamespaces != null && this.userDefinedNamespaces.containsKey(prefix)) {
                return this.userDefinedNamespaces.get(prefix);
            }
            return this.sourceDocument.lookupNamespaceURI(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this.sourceDocument.lookupPrefix(namespaceURI);
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

