/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.wizards;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewModuleInfoDialog;
import org.eclipse.reddeer.eclipse.selectionwizard.NewMenuWizard;
import org.eclipse.reddeer.jface.api.Window;
import org.eclipse.reddeer.jface.condition.WindowIsAvailable;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;

public class JavaProjectWizard
extends NewMenuWizard {
    public JavaProjectWizard() {
        super("New Java Project", "Java", "Java Project");
    }

    public void finish(TimePeriod timeout) {
        this.finish(timeout, false, "");
    }

    public void finish(boolean createModule, String moduleName) {
        this.finish(TimePeriod.LONG, createModule, moduleName);
    }

    public void finish(TimePeriod timeout, boolean createModule, String moduleName) {
        this.checkShell();
        this.log.info("Finish wizard");
        FinishButton button = new FinishButton((ReferencedComposite)this);
        button.click();
        ShellIsAvailable moduleShell = new ShellIsAvailable("New module-info.java");
        new WaitUntil((WaitCondition)moduleShell, TimePeriod.MEDIUM, false);
        if (moduleShell.getResult() != null) {
            NewModuleInfoDialog moduleDialog = new NewModuleInfoDialog((Shell)new DefaultShell(moduleShell.getResult()));
            if (createModule) {
                if (moduleName != null && !moduleName.isEmpty()) {
                    moduleDialog.setModuleName(moduleName);
                }
                moduleDialog.create();
            } else {
                moduleDialog.dontCreate();
            }
            new WaitWhile((WaitCondition)moduleShell, TimePeriod.DEFAULT);
        }
        new WaitWhile((WaitCondition)new WindowIsAvailable((Window)this), timeout);
        new WaitWhile((WaitCondition)new JobIsRunning(), timeout);
    }
}

